/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckCorruptedCacheStoresCleanAction
implements MaintenanceAction<Boolean> {
    public static final String ACTION_NAME = "check_cache_files_cleaned";
    private final File rootStoreDir;
    private final String[] cacheStoreDirs;

    public CheckCorruptedCacheStoresCleanAction(File rootStoreDir, String[] cacheStoreDirs) {
        this.rootStoreDir = rootStoreDir;
        this.cacheStoreDirs = cacheStoreDirs;
    }

    @Override
    public Boolean execute() {
        for (String cacheStoreDirName : this.cacheStoreDirs) {
            File cacheStoreDir = new File(this.rootStoreDir, cacheStoreDirName);
            if (!cacheStoreDir.exists() || !cacheStoreDir.isDirectory()) continue;
            for (File f : cacheStoreDir.listFiles()) {
                if (f.getName().equals("cache_data.dat")) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    @NotNull
    public String name() {
        return ACTION_NAME;
    }

    @Override
    @Nullable
    public String description() {
        return "Checks if all corrupted data files are cleaned from cache store directories";
    }
}

