/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.logging.Logger;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;

public interface Command<T> {
    public static GridClient startClient(GridClientConfiguration clientCfg) throws Exception {
        GridClient client = GridClientFactory.start(clientCfg);
        if (!client.connected()) {
            client.throwLastError();
        }
        return client;
    }

    public static void usage(Logger logger, String desc, CommandList cmd, String ... args) {
        logger.info("  " + desc);
        logger.info("    " + CommandLogger.join(" ", new Object[]{"control.(sh|bat)", cmd, CommandLogger.join(" ", args)}));
        logger.info("");
    }

    public Object execute(GridClientConfiguration var1, Logger var2) throws Exception;

    default public void prepareConfirmation(GridClientConfiguration clientCfg) throws Exception {
    }

    default public String confirmationPrompt() {
        return null;
    }

    default public void parseArguments(CommandArgIterator argIterator) {
    }

    public T arg();

    public void printUsage(Logger var1);

    public String name();
}

