/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.jetbrains.annotations.Nullable;

public class ClientListenerNioServerBuffer {
    private byte[] data;
    private int cnt = -4;
    private int msgSize;

    public void reset() {
        this.msgSize = 0;
        this.cnt = -4;
        this.data = null;
    }

    public boolean isFilled() {
        return this.cnt > 0 && this.cnt == this.msgSize;
    }

    public byte[] data() {
        return this.data;
    }

    @Nullable
    public byte[] read(ByteBuffer buf) throws IgniteCheckedException {
        int missing;
        if (this.cnt < 0) {
            while (this.cnt < 0 && buf.hasRemaining()) {
                this.msgSize |= (buf.get() & 0xFF) << 8 * (4 + this.cnt);
                ++this.cnt;
            }
            if (this.cnt < 0) {
                return null;
            }
            if (this.msgSize <= 0) {
                throw new IgniteCheckedException("Invalid message size: " + this.msgSize);
            }
            this.data = new byte[this.msgSize];
        }
        assert (this.msgSize > 0);
        assert (this.cnt >= 0);
        int remaining = buf.remaining();
        if (remaining > 0 && (missing = this.msgSize - this.cnt) > 0) {
            int len = missing < remaining ? missing : remaining;
            buf.get(this.data, this.cnt, len);
            this.cnt += len;
        }
        if (this.cnt == this.msgSize) {
            byte[] data0 = this.data;
            this.reset();
            return data0;
        }
        return null;
    }
}

