/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.OutputStream;
import java.util.Map;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystem;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgfsSecondaryFileSystemCreateContext {
    private final IgfsSecondaryFileSystem fs;
    private final IgfsPath path;
    private final boolean overwrite;
    private final boolean simpleCreate;
    private final Map<String, String> props;
    private final short replication;
    private final long blockSize;
    private final int bufSize;

    public IgfsSecondaryFileSystemCreateContext(IgfsSecondaryFileSystem fs, IgfsPath path, boolean overwrite, boolean simpleCreate, @Nullable Map<String, String> props, short replication, long blockSize, int bufSize) {
        assert (fs != null);
        this.fs = fs;
        this.path = path;
        this.overwrite = overwrite;
        this.simpleCreate = simpleCreate;
        this.props = props;
        this.replication = replication;
        this.blockSize = blockSize;
        this.bufSize = bufSize;
    }

    public OutputStream create() {
        return this.simpleCreate ? this.fs.create(this.path, this.overwrite) : this.fs.create(this.path, this.bufSize, this.overwrite, this.replication, this.blockSize, this.props);
    }

    public IgfsFile info() {
        return this.fs.info(this.path);
    }

    public IgfsSecondaryFileSystem fileSystem() {
        return this.fs;
    }

    public String toString() {
        return S.toString(IgfsSecondaryFileSystemCreateContext.class, this);
    }
}

