/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree.mvcc.search;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.mvcc.MvccUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccSearchRow;
import org.apache.ignite.internal.processors.cache.tree.mvcc.search.MvccTreeClosure;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class MvccSnapshotSearchRow
extends MvccSearchRow
implements MvccTreeClosure {
    private final GridCacheContext cctx;
    private CacheDataRow res;
    private MvccSnapshot snapshot;

    public MvccSnapshotSearchRow(GridCacheContext cctx, KeyCacheObject key, MvccSnapshot snapshot) {
        super(cctx.cacheId(), key, snapshot.coordinatorVersion(), snapshot.counter(), 0x1FFFFFFF);
        this.cctx = cctx;
        this.snapshot = snapshot;
    }

    @Nullable
    public CacheDataRow row() {
        return this.res;
    }

    @Override
    public boolean apply(BPlusTree<CacheSearchRow, CacheDataRow> tree, BPlusIO<CacheSearchRow> io, long pageAddr, int idx) throws IgniteCheckedException {
        RowLinkIO rowIo = (RowLinkIO)((Object)io);
        long rowCrdVer = rowIo.getMvccCoordinatorVersion(pageAddr, idx);
        long rowCntr = rowIo.getMvccCounter(pageAddr, idx);
        int rowOpCntr = rowIo.getMvccOperationCounter(pageAddr, idx);
        assert (MvccUtils.mvccVersionIsValid(rowCrdVer, rowCntr, rowOpCntr));
        if (MvccUtils.isVisible(this.cctx, this.snapshot, rowCrdVer, rowCntr, rowOpCntr, false)) {
            int state = MvccUtils.getVisibleState(this.cctx, rowIo.getLink(pageAddr, idx), this.snapshot);
            if (state == 0) {
                return true;
            }
            if (state == 1) {
                this.res = null;
            } else {
                assert (state == 2);
                this.res = tree.getRow(io, pageAddr, idx, (Object)CacheDataRowAdapter.RowData.NO_KEY);
                this.res.key(this.key());
            }
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return S.toString(MvccSnapshotSearchRow.class, this);
    }
}

