/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.metric.IndexPageType;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxLogInnerIO;
import org.apache.ignite.internal.processors.cache.mvcc.txlog.TxLogLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.IndexStorageImpl;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListNodeIO;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageBPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastoreDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusInnerIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionCountersIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PagePartitionMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.SimpleDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.TrackingPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.processors.cache.tree.CacheIdAwareDataInnerIO;
import org.apache.ignite.internal.processors.cache.tree.CacheIdAwareDataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.CacheIdAwarePendingEntryInnerIO;
import org.apache.ignite.internal.processors.cache.tree.CacheIdAwarePendingEntryLeafIO;
import org.apache.ignite.internal.processors.cache.tree.DataInnerIO;
import org.apache.ignite.internal.processors.cache.tree.DataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.PendingEntryInnerIO;
import org.apache.ignite.internal.processors.cache.tree.PendingEntryLeafIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccCacheIdAwareDataInnerIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccCacheIdAwareDataLeafIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataInnerIO;
import org.apache.ignite.internal.processors.cache.tree.mvcc.data.MvccDataLeafIO;
import org.apache.ignite.internal.util.GridStringBuilder;

public abstract class PageIO {
    private static PageIO testIO;
    private static BPlusInnerIO<?> innerTestIO;
    private static BPlusLeafIO<?> leafTestIO;
    private static IOVersions<? extends BPlusInnerIO<?>> h2InnerIOs;
    private static IOVersions<? extends BPlusLeafIO<?>> h2LeafIOs;
    private static IOVersions<? extends BPlusInnerIO<?>> h2MvccInnerIOs;
    private static IOVersions<? extends BPlusLeafIO<?>> h2MvccLeafIOs;
    public static final short MAX_PAYLOAD_SIZE = 2048;
    private static List<IOVersions<? extends BPlusInnerIO<?>>> h2ExtraInnerIOs;
    private static List<IOVersions<? extends BPlusLeafIO<?>>> h2ExtraLeafIOs;
    private static List<IOVersions<? extends BPlusInnerIO<?>>> h2ExtraMvccInnerIOs;
    private static List<IOVersions<? extends BPlusLeafIO<?>>> h2ExtraMvccLeafIOs;
    public static final int TYPE_OFF = 0;
    public static final int VER_OFF = 2;
    public static final int CRC_OFF = 4;
    public static final int PAGE_ID_OFF = 8;
    public static final int ROTATED_ID_PART_OFF = 16;
    private static final int COMPRESSION_TYPE_OFF = 17;
    private static final int COMPRESSED_SIZE_OFF = 18;
    private static final int COMPACTED_SIZE_OFF = 20;
    private static final int RESERVED_SHORT_OFF = 22;
    private static final int RESERVED_2_OFF = 24;
    private static final int RESERVED_3_OFF = 32;
    public static final int COMMON_HEADER_END = 40;
    public static final short T_DATA = 1;
    public static final short T_BPLUS_META = 2;
    public static final short T_H2_REF_LEAF = 3;
    public static final short T_H2_REF_INNER = 4;
    public static final short T_DATA_REF_INNER = 5;
    public static final short T_DATA_REF_LEAF = 6;
    public static final short T_METASTORE_INNER = 7;
    public static final short T_METASTORE_LEAF = 8;
    public static final short T_PENDING_REF_INNER = 9;
    public static final short T_PENDING_REF_LEAF = 10;
    public static final short T_META = 11;
    public static final short T_PAGE_LIST_META = 12;
    public static final short T_PAGE_LIST_NODE = 13;
    public static final short T_PART_META = 14;
    public static final short T_PAGE_UPDATE_TRACKING = 15;
    public static final short T_CACHE_ID_AWARE_DATA_REF_INNER = 16;
    public static final short T_CACHE_ID_AWARE_DATA_REF_LEAF = 17;
    public static final short T_CACHE_ID_AWARE_PENDING_REF_INNER = 18;
    public static final short T_CACHE_ID_AWARE_PENDING_REF_LEAF = 19;
    public static final short T_PART_CNTRS = 20;
    public static final short T_DATA_METASTORAGE = 21;
    public static final short T_DATA_REF_METASTORAGE_INNER = 22;
    public static final short T_DATA_REF_METASTORAGE_LEAF = 23;
    public static final short T_DATA_REF_MVCC_INNER = 24;
    public static final short T_DATA_REF_MVCC_LEAF = 25;
    public static final short T_CACHE_ID_DATA_REF_MVCC_INNER = 26;
    public static final short T_CACHE_ID_DATA_REF_MVCC_LEAF = 27;
    public static final short T_H2_MVCC_REF_LEAF = 28;
    public static final short T_H2_MVCC_REF_INNER = 29;
    public static final short T_TX_LOG_LEAF = 30;
    public static final short T_TX_LOG_INNER = 31;
    public static final short T_DATA_PART = 32;
    public static final short T_H2_EX_REF_LEAF_START = 10000;
    public static final short T_H2_EX_REF_LEAF_END = 12047;
    public static final short T_H2_EX_REF_INNER_START = 20000;
    public static final short T_H2_EX_REF_INNER_END = 22047;
    public static final short T_H2_EX_REF_MVCC_LEAF_START = 23000;
    public static final short T_H2_EX_REF_MVCC_LEAF_END = 25047;
    public static final short T_H2_EX_REF_MVCC_INNER_START = 26000;
    public static final short T_H2_EX_REF_MVCC_INNER_END = 28047;
    private final int ver;
    private final int type;

    protected PageIO(int type, int ver) {
        assert (ver > 0 && ver < 65535) : ver;
        assert (type > 0 && type < 65535) : type;
        this.type = type;
        this.ver = ver;
    }

    public static int getType(ByteBuffer buf) {
        return buf.getShort(0) & 0xFFFF;
    }

    public static int getType(long pageAddr) {
        return PageUtils.getShort(pageAddr, 0) & 0xFFFF;
    }

    public static void setType(long pageAddr, int type) {
        PageUtils.putShort(pageAddr, 0, (short)type);
        assert (PageIO.getType(pageAddr) == type) : PageIO.getType(pageAddr);
    }

    public static int getVersion(ByteBuffer buf) {
        return buf.getShort(2) & 0xFFFF;
    }

    public static int getVersion(long pageAddr) {
        return PageUtils.getShort(pageAddr, 2) & 0xFFFF;
    }

    protected static void setVersion(long pageAddr, int ver) {
        PageUtils.putShort(pageAddr, 2, (short)ver);
        assert (PageIO.getVersion(pageAddr) == ver);
    }

    public static long getPageId(ByteBuffer buf) {
        return buf.getLong(8);
    }

    public static long getPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 8);
    }

    public static void setPageId(long pageAddr, long pageId) {
        PageUtils.putLong(pageAddr, 8, pageId);
        assert (PageIO.getPageId(pageAddr) == pageId);
    }

    public static int getRotatedIdPart(long pageAddr) {
        return PageUtils.getUnsignedByte(pageAddr, 16);
    }

    public static void setRotatedIdPart(long pageAddr, int rotatedIdPart) {
        PageUtils.putUnsignedByte(pageAddr, 16, rotatedIdPart);
        assert (PageIO.getRotatedIdPart(pageAddr) == rotatedIdPart);
    }

    public static void setCompressionType(ByteBuffer page, byte compressType) {
        page.put(17, compressType);
    }

    public static byte getCompressionType(ByteBuffer page) {
        return page.get(17);
    }

    public static byte getCompressionType(long pageAddr) {
        return PageUtils.getByte(pageAddr, 17);
    }

    public static void setCompressedSize(ByteBuffer page, short compressedSize) {
        page.putShort(18, compressedSize);
    }

    public static short getCompressedSize(ByteBuffer page) {
        return page.getShort(18);
    }

    public static short getCompressedSize(long pageAddr) {
        return PageUtils.getShort(pageAddr, 18);
    }

    public static void setCompactedSize(ByteBuffer page, short compactedSize) {
        page.putShort(20, compactedSize);
    }

    public static short getCompactedSize(ByteBuffer page) {
        return page.getShort(20);
    }

    public static short getCompactedSize(long pageAddr) {
        return PageUtils.getShort(pageAddr, 20);
    }

    public static int getCrc(long pageAddr) {
        return PageUtils.getInt(pageAddr, 4);
    }

    public static void setCrc(long pageAddr, int crc) {
        PageUtils.putInt(pageAddr, 4, crc);
    }

    public static int getCrc(ByteBuffer buf) {
        return buf.getInt(4);
    }

    public static void setCrc(ByteBuffer buf, int crc) {
        buf.putInt(4, crc);
    }

    public static void registerH2(IOVersions<? extends BPlusInnerIO<?>> innerIOs, IOVersions<? extends BPlusLeafIO<?>> leafIOs, IOVersions<? extends BPlusInnerIO<?>> mvccInnerIOs, IOVersions<? extends BPlusLeafIO<?>> mvccLeafIOs) {
        h2InnerIOs = innerIOs;
        h2LeafIOs = leafIOs;
        h2MvccInnerIOs = mvccInnerIOs;
        h2MvccLeafIOs = mvccLeafIOs;
    }

    public static void registerH2ExtraInner(IOVersions<? extends BPlusInnerIO<?>> innerExtIOs, boolean mvcc) {
        List<IOVersions<BPlusInnerIO<?>>> ios = mvcc ? h2ExtraMvccInnerIOs : h2ExtraInnerIOs;
        ios.add(innerExtIOs);
    }

    public static void registerH2ExtraLeaf(IOVersions<? extends BPlusLeafIO<?>> leafExtIOs, boolean mvcc) {
        List<IOVersions<BPlusLeafIO<?>>> ios = mvcc ? h2ExtraMvccLeafIOs : h2ExtraLeafIOs;
        ios.add(leafExtIOs);
    }

    public static IOVersions<? extends BPlusInnerIO<?>> getInnerVersions(int idx, boolean mvcc) {
        List<IOVersions<BPlusInnerIO<?>>> ios = mvcc ? h2ExtraMvccInnerIOs : h2ExtraInnerIOs;
        return ios.get(idx);
    }

    public static IOVersions<? extends BPlusLeafIO<?>> getLeafVersions(int idx, boolean mvcc) {
        List<IOVersions<BPlusLeafIO<?>>> ios = mvcc ? h2ExtraMvccLeafIOs : h2ExtraLeafIOs;
        return ios.get(idx);
    }

    public static void registerTest(BPlusInnerIO<?> innerIO, BPlusLeafIO<?> leafIO) {
        innerTestIO = innerIO;
        leafTestIO = leafIO;
    }

    public static void registerTest(PageIO io) {
        testIO = io;
    }

    public final int getType() {
        return this.type;
    }

    public final int getVersion() {
        return this.ver;
    }

    public void initNewPage(long pageAddr, long pageId, int pageSize) {
        PageIO.setType(pageAddr, this.getType());
        PageIO.setVersion(pageAddr, this.getVersion());
        PageIO.setPageId(pageAddr, pageId);
        PageIO.setCrc(pageAddr, 0);
        PageUtils.putLong(pageAddr, 16, 0L);
        PageUtils.putLong(pageAddr, 24, 0L);
        PageUtils.putLong(pageAddr, 32, 0L);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[ver=" + this.getVersion() + "]";
    }

    public static <Q extends PageIO> Q getPageIO(long pageAddr) throws IgniteCheckedException {
        int type = PageIO.getType(pageAddr);
        int ver = PageIO.getVersion(pageAddr);
        return PageIO.getPageIO(type, ver);
    }

    public static <Q extends PageIO> Q getPageIO(ByteBuffer page) throws IgniteCheckedException {
        return PageIO.getPageIO(PageIO.getType(page), PageIO.getVersion(page));
    }

    public static <Q extends PageIO> Q getPageIO(int type, int ver) throws IgniteCheckedException {
        switch (type) {
            case 1: {
                return (Q)DataPageIO.VERSIONS.forVersion(ver);
            }
            case 2: {
                return (Q)BPlusMetaIO.VERSIONS.forVersion(ver);
            }
            case 13: {
                return (Q)PagesListNodeIO.VERSIONS.forVersion(ver);
            }
            case 12: {
                return (Q)PagesListMetaIO.VERSIONS.forVersion(ver);
            }
            case 11: {
                return (Q)PageMetaIO.VERSIONS.forVersion(ver);
            }
            case 14: {
                return (Q)PagePartitionMetaIO.VERSIONS.forVersion(ver);
            }
            case 20: {
                return (Q)PagePartitionCountersIO.VERSIONS.forVersion(ver);
            }
            case 15: {
                return (Q)TrackingPageIO.VERSIONS.forVersion(ver);
            }
            case 21: {
                return (Q)MetastoreDataPageIO.VERSIONS.forVersion(ver);
            }
            case 32: {
                return (Q)SimpleDataPageIO.VERSIONS.forVersion(ver);
            }
        }
        if (testIO != null && PageIO.testIO.type == type && PageIO.testIO.ver == ver) {
            return (Q)testIO;
        }
        return PageIO.getBPlusIO(type, ver);
    }

    public static <Q extends BPlusIO<?>> Q getBPlusIO(long pageAddr) throws IgniteCheckedException {
        int type = PageIO.getType(pageAddr);
        int ver = PageIO.getVersion(pageAddr);
        return PageIO.getBPlusIO(type, ver);
    }

    public static <Q extends BPlusIO<?>> Q getBPlusIO(int type, int ver) throws IgniteCheckedException {
        if (type >= 10000 && type <= 12047) {
            return (Q)h2ExtraLeafIOs.get(type - 10000).forVersion(ver);
        }
        if (type >= 20000 && type <= 22047) {
            return (Q)h2ExtraInnerIOs.get(type - 20000).forVersion(ver);
        }
        if (type >= 23000 && type <= 25047) {
            return (Q)h2ExtraMvccLeafIOs.get(type - 23000).forVersion(ver);
        }
        if (type >= 26000 && type <= 28047) {
            return (Q)h2ExtraMvccInnerIOs.get(type - 26000).forVersion(ver);
        }
        switch (type) {
            case 4: {
                if (h2InnerIOs == null) break;
                return (Q)h2InnerIOs.forVersion(ver);
            }
            case 3: {
                if (h2LeafIOs == null) break;
                return (Q)h2LeafIOs.forVersion(ver);
            }
            case 29: {
                if (h2MvccInnerIOs == null) break;
                return (Q)h2MvccInnerIOs.forVersion(ver);
            }
            case 28: {
                if (h2MvccLeafIOs == null) break;
                return (Q)h2MvccLeafIOs.forVersion(ver);
            }
            case 31: {
                return (Q)TxLogInnerIO.VERSIONS.forVersion(ver);
            }
            case 30: {
                return (Q)TxLogLeafIO.VERSIONS.forVersion(ver);
            }
            case 5: {
                return (Q)DataInnerIO.VERSIONS.forVersion(ver);
            }
            case 6: {
                return (Q)DataLeafIO.VERSIONS.forVersion(ver);
            }
            case 16: {
                return (Q)CacheIdAwareDataInnerIO.VERSIONS.forVersion(ver);
            }
            case 17: {
                return (Q)CacheIdAwareDataLeafIO.VERSIONS.forVersion(ver);
            }
            case 26: {
                return (Q)MvccCacheIdAwareDataInnerIO.VERSIONS.forVersion(ver);
            }
            case 27: {
                return (Q)MvccCacheIdAwareDataLeafIO.VERSIONS.forVersion(ver);
            }
            case 24: {
                return (Q)MvccDataInnerIO.VERSIONS.forVersion(ver);
            }
            case 25: {
                return (Q)MvccDataLeafIO.VERSIONS.forVersion(ver);
            }
            case 7: {
                return (Q)IndexStorageImpl.MetaStoreInnerIO.VERSIONS.forVersion(ver);
            }
            case 8: {
                return (Q)IndexStorageImpl.MetaStoreLeafIO.VERSIONS.forVersion(ver);
            }
            case 9: {
                return (Q)PendingEntryInnerIO.VERSIONS.forVersion(ver);
            }
            case 10: {
                return (Q)PendingEntryLeafIO.VERSIONS.forVersion(ver);
            }
            case 18: {
                return (Q)CacheIdAwarePendingEntryInnerIO.VERSIONS.forVersion(ver);
            }
            case 19: {
                return (Q)CacheIdAwarePendingEntryLeafIO.VERSIONS.forVersion(ver);
            }
            case 22: {
                return (Q)MetastorageBPlusIO.INNER_IO_VERSIONS.forVersion(ver);
            }
            case 23: {
                return (Q)MetastorageBPlusIO.LEAF_IO_VERSIONS.forVersion(ver);
            }
            default: {
                if (innerTestIO != null && innerTestIO.getType() == type && innerTestIO.getVersion() == ver) {
                    return (Q)innerTestIO;
                }
                if (leafTestIO == null || leafTestIO.getType() != type || leafTestIO.getVersion() != ver) break;
                return (Q)leafTestIO;
            }
        }
        throw new IgniteCheckedException("Unknown page IO type: " + type);
    }

    public static IndexPageType deriveIndexPageType(long pageAddr) {
        int pageIoType = PageIO.getType(pageAddr);
        switch (pageIoType) {
            case 4: 
            case 5: 
            case 16: 
            case 24: 
            case 26: 
            case 29: {
                return IndexPageType.INNER;
            }
            case 3: 
            case 6: 
            case 17: 
            case 25: 
            case 27: 
            case 28: {
                return IndexPageType.LEAF;
            }
        }
        if (10000 <= pageIoType && pageIoType <= 12047 || 23000 <= pageIoType && pageIoType <= 25047) {
            return IndexPageType.LEAF;
        }
        if (20000 <= pageIoType && pageIoType <= 22047 || 26000 <= pageIoType && pageIoType <= 28047) {
            return IndexPageType.INNER;
        }
        return IndexPageType.NOT_INDEX;
    }

    public static boolean isDataPageType(int type) {
        return type == 1;
    }

    protected abstract void printPage(long var1, int var3, GridStringBuilder var4) throws IgniteCheckedException;

    protected final void copyPage(ByteBuffer page, ByteBuffer out, int pageSize) {
        assert (out.position() == 0);
        assert (pageSize <= out.remaining());
        assert (pageSize == page.remaining());
        PageHandler.copyMemory(page, 0L, out, 0L, (long)pageSize);
        out.limit(pageSize);
    }

    public static String printPage(long addr, int pageSize) {
        GridStringBuilder sb = new GridStringBuilder("Header [\n\ttype=");
        try {
            Object io = PageIO.getPageIO(addr);
            sb.a(PageIO.getType(addr)).a(" (").a(io.getClass().getSimpleName()).a("),\n\tver=").a(PageIO.getVersion(addr)).a(",\n\tcrc=").a(PageIO.getCrc(addr)).a(",\n\t").a(PageIdUtils.toDetailString(PageIO.getPageId(addr))).a("\n],\n");
            if (PageIO.getCompressionType(addr) != 0) {
                sb.a("CompressedPage[\n\tcompressionType=").a(PageIO.getCompressionType(addr)).a(",\n\tcompressedSize=").a(PageIO.getCompressedSize(addr)).a(",\n\tcompactedSize=").a(PageIO.getCompactedSize(addr)).a("\n]");
            } else {
                ((PageIO)io).printPage(addr, pageSize, sb);
            }
        }
        catch (IgniteCheckedException e) {
            sb.a("Failed to print page: ").a(e.getMessage());
        }
        return sb.toString();
    }

    static {
        h2ExtraInnerIOs = new ArrayList(2048);
        h2ExtraLeafIOs = new ArrayList(2048);
        h2ExtraMvccInnerIOs = new ArrayList(2048);
        h2ExtraMvccLeafIOs = new ArrayList(2048);
    }
}

