/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.IgniteVersionUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class IgniteProductVersion
implements Comparable<IgniteProductVersion>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final Pattern VER_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)([-.]([^0123456789][^-]+)(-SNAPSHOT)?)?(-(\\d+))?(-([\\da-f]+))?");
    private byte major;
    private byte minor;
    private byte maintenance;
    private String stage;
    private long revTs;
    private byte[] revHash;

    public IgniteProductVersion() {
    }

    public IgniteProductVersion(byte major, byte minor, byte maintenance, long revTs, byte[] revHash) {
        this(major, minor, maintenance, "", revTs, revHash);
    }

    public IgniteProductVersion(byte major, byte minor, byte maintenance, String stage, long revTs, byte[] revHash) {
        if (revHash != null && revHash.length != 20) {
            throw new IllegalArgumentException("Invalid length for SHA1 hash (must be 20): " + revHash.length);
        }
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.stage = stage;
        this.revTs = revTs;
        this.revHash = revHash != null ? revHash : new byte[20];
    }

    public byte major() {
        return this.major;
    }

    public byte minor() {
        return this.minor;
    }

    public byte maintenance() {
        return this.maintenance;
    }

    public String stage() {
        return this.stage;
    }

    public long revisionTimestamp() {
        return this.revTs;
    }

    public byte[] revisionHash() {
        return this.revHash;
    }

    public Date releaseDate() {
        return new Date(this.revTs * 1000L);
    }

    public boolean greaterThanEqual(int major, int minor, int maintenance) {
        if (major == this.major) {
            return minor == this.minor ? this.maintenance >= maintenance : this.minor > minor;
        }
        return this.major > major;
    }

    @Override
    public int compareTo(@NotNull IgniteProductVersion o) {
        int res = Integer.compare(this.major, o.major);
        if (res != 0) {
            return res;
        }
        res = Integer.compare(this.minor, o.minor);
        if (res != 0) {
            return res;
        }
        res = Integer.compare(this.maintenance, o.maintenance);
        if (res != 0) {
            return res;
        }
        return Long.compare(this.revTs, o.revTs);
    }

    public int compareToIgnoreTimestamp(@NotNull IgniteProductVersion o) {
        int res = Integer.compare(this.major, o.major);
        if (res != 0) {
            return res;
        }
        res = Integer.compare(this.minor, o.minor);
        if (res != 0) {
            return res;
        }
        return Integer.compare(this.maintenance, o.maintenance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IgniteProductVersion)) {
            return false;
        }
        IgniteProductVersion that = (IgniteProductVersion)o;
        return this.revTs == that.revTs && this.maintenance == that.maintenance && this.minor == that.minor && this.major == that.major;
    }

    public int hashCode() {
        int res = this.major;
        res = 31 * res + this.minor;
        res = 31 * res + this.maintenance;
        res = 31 * res + (int)(this.revTs ^ this.revTs >>> 32);
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.major);
        out.writeByte(this.minor);
        out.writeByte(this.maintenance);
        out.writeLong(this.revTs);
        U.writeByteArray(out, this.revHash);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.major = in.readByte();
        this.minor = in.readByte();
        this.maintenance = in.readByte();
        this.revTs = in.readLong();
        this.revHash = U.readByteArray(in);
    }

    public String toString() {
        String revTsStr = IgniteVersionUtils.formatBuildTimeStamp(this.revTs * 1000L);
        String hash = U.byteArray2HexString(this.revHash).toLowerCase();
        hash = hash.length() > 8 ? hash.substring(0, 8) : hash;
        return this.major + "." + this.minor + "." + this.maintenance + "#" + revTsStr + "-sha1:" + hash;
    }

    public static IgniteProductVersion fromString(String verStr) {
        Matcher match;
        assert (verStr != null);
        if (verStr.endsWith("-DEV") || verStr.endsWith("-n/a")) {
            verStr = verStr.substring(0, verStr.length() - 4);
        }
        if ((match = VER_PATTERN.matcher(verStr)).matches()) {
            try {
                byte major = Byte.parseByte(match.group(1));
                byte minor = Byte.parseByte(match.group(2));
                byte maintenance = Byte.parseByte(match.group(3));
                String stage = "";
                if (match.group(4) != null) {
                    stage = match.group(4).substring(1);
                }
                long revTs = 0L;
                if (match.group(7) != null) {
                    revTs = Long.parseLong(match.group(8));
                }
                byte[] revHash = null;
                if (match.group(9) != null) {
                    revHash = U.decodeHex(match.group(10).toCharArray());
                }
                return new IgniteProductVersion(major, minor, maintenance, stage, revTs, revHash);
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NumberFormatException | IgniteCheckedException e) {
                throw new IllegalStateException("Failed to parse version: " + verStr, e);
            }
        }
        throw new IllegalStateException("Failed to parse version: " + verStr);
    }
}

