/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.collection;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.util.collection.IntHashMap;
import org.apache.ignite.internal.util.collection.IntMap;

public class IntRWHashMap<V>
implements IntMap<V> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final IntHashMap<V> delegate = new IntHashMap();

    @Override
    public V get(int key) {
        this.lock.readLock().lock();
        try {
            V v = this.delegate.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(int key, V val) {
        this.lock.writeLock().lock();
        try {
            V v = this.delegate.put(key, val);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public V remove(int key) {
        this.lock.writeLock().lock();
        try {
            V v = this.delegate.remove(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(int key, V val) {
        this.lock.writeLock().lock();
        try {
            V v = this.delegate.putIfAbsent(key, val);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public <E extends Throwable> void forEach(IntMap.EntryConsumer<V, E> act) throws E {
        this.lock.readLock().lock();
        try {
            this.delegate.forEach(act);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(int key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean containsValue(V val) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.delegate.containsValue(val);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

