/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridEmptyIterator;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.lang.GridAbsClosure;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.GridNodePredicate;
import org.apache.ignite.internal.util.lang.GridTuple;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.lang.GridTuple4;
import org.apache.ignite.internal.util.lang.GridTuple5;
import org.apache.ignite.internal.util.lang.GridTuple6;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.lang.gridfunc.AlwaysFalsePredicate;
import org.apache.ignite.internal.util.lang.gridfunc.AlwaysTruePredicate;
import org.apache.ignite.internal.util.lang.gridfunc.AlwaysTrueReducer;
import org.apache.ignite.internal.util.lang.gridfunc.AtomicIntegerFactoryCallable;
import org.apache.ignite.internal.util.lang.gridfunc.CacheEntryGetValueClosure;
import org.apache.ignite.internal.util.lang.gridfunc.CacheEntryHasPeekPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.ClusterNodeGetIdClosure;
import org.apache.ignite.internal.util.lang.gridfunc.ConcurrentHashSetFactoryCallable;
import org.apache.ignite.internal.util.lang.gridfunc.ConcurrentMapFactoryCallable;
import org.apache.ignite.internal.util.lang.gridfunc.ContainsNodeIdsPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.ContainsPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.EqualsClusterNodeIdPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.EqualsUuidPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.FlatCollectionWrapper;
import org.apache.ignite.internal.util.lang.gridfunc.FlatIterator;
import org.apache.ignite.internal.util.lang.gridfunc.HasEqualIdPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.HasNotEqualIdPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.IdentityClosure;
import org.apache.ignite.internal.util.lang.gridfunc.IntSumReducer;
import org.apache.ignite.internal.util.lang.gridfunc.IsAllPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.IsNotAllPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.IsNotNullPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.LongSumReducer;
import org.apache.ignite.internal.util.lang.gridfunc.MapFactoryCallable;
import org.apache.ignite.internal.util.lang.gridfunc.MultipleIterator;
import org.apache.ignite.internal.util.lang.gridfunc.NoOpClosure;
import org.apache.ignite.internal.util.lang.gridfunc.NotContainsPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.NotEqualPredicate;
import org.apache.ignite.internal.util.lang.gridfunc.PredicateCollectionView;
import org.apache.ignite.internal.util.lang.gridfunc.PredicateMapView;
import org.apache.ignite.internal.util.lang.gridfunc.PredicateSetView;
import org.apache.ignite.internal.util.lang.gridfunc.ReadOnlyCollectionView;
import org.apache.ignite.internal.util.lang.gridfunc.ReadOnlyCollectionView2X;
import org.apache.ignite.internal.util.lang.gridfunc.RunnableWrapperClosure;
import org.apache.ignite.internal.util.lang.gridfunc.SetFactoryCallable;
import org.apache.ignite.internal.util.lang.gridfunc.StringConcatReducer;
import org.apache.ignite.internal.util.lang.gridfunc.ToStringClosure;
import org.apache.ignite.internal.util.lang.gridfunc.TransformCollectionView;
import org.apache.ignite.internal.util.lang.gridfunc.TransformFilteringIterator;
import org.apache.ignite.internal.util.lang.gridfunc.TransformMapView;
import org.apache.ignite.internal.util.lang.gridfunc.TransformMapView2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteReducer;
import org.jetbrains.annotations.Nullable;

public class GridFunc {
    private static final GridAbsClosure NOOP = new NoOpClosure();
    private static final IgniteClosure IDENTITY = new IdentityClosure();
    private static final IgnitePredicate<Object> ALWAYS_TRUE = new AlwaysTruePredicate<Object>();
    private static final IgnitePredicate<Object> ALWAYS_FALSE = new AlwaysFalsePredicate<Object>();
    private static final IgnitePredicate<Object> IS_NOT_NULL = new IsNotNullPredicate<Object>();
    private static final IgniteCallable<?> SET_FACTORY = new SetFactoryCallable();
    private static final IgniteCallable<AtomicInteger> ATOMIC_INT_FACTORY = new AtomicIntegerFactoryCallable();
    private static final IgniteCallable<?> MAP_FACTORY = new MapFactoryCallable();
    private static final IgniteCallable<?> CONCURRENT_MAP_FACTORY = new ConcurrentMapFactoryCallable();
    private static final IgniteCallable<?> CONCURRENT_SET_FACTORY = new ConcurrentHashSetFactoryCallable();
    private static final IgniteClosure CACHE_ENTRY_VAL_GET = new CacheEntryGetValueClosure();
    private static final IgnitePredicate CACHE_ENTRY_HAS_PEEK_VAL = new CacheEntryHasPeekPredicate();
    private static final IgniteClosure<ClusterNode, UUID> NODE2ID = new ClusterNodeGetIdClosure();
    private static final IgniteClosure<BaselineNode, Object> NODE2CONSISTENTID = new IgniteClosure<BaselineNode, Object>(){

        @Override
        public Object apply(BaselineNode node) {
            return node.consistentId();
        }
    };

    public static <T extends ClusterNode> IgnitePredicate<T> localNode(UUID locNodeId) {
        return new HasEqualIdPredicate(locNodeId);
    }

    public static <T extends ClusterNode> IgnitePredicate<T> remoteNodes(UUID locNodeId) {
        return new HasNotEqualIdPredicate(locNodeId);
    }

    @Deprecated
    public static <T> Collection<T> dedup(Collection<? extends T> c) {
        A.notNull(c, "c");
        GridLeanSet<? extends T> set = new GridLeanSet<T>();
        set.addAll(c);
        return set;
    }

    public static int sumInt(Iterable<Integer> c) {
        A.notNull(c, "c");
        int sum = 0;
        for (int t : c) {
            sum += t;
        }
        return sum;
    }

    public static <T> IgniteReducer<T, T> identityReducer(T elem) {
        return new AlwaysTrueReducer<T>(elem);
    }

    @Deprecated
    public static IgniteReducer<Integer, Integer> sumIntReducer() {
        return new IntSumReducer();
    }

    @Deprecated
    public static IgniteReducer<Long, Long> sumLongReducer() {
        return new LongSumReducer();
    }

    @Deprecated
    public static List<Integer> range(int fromIncl, int toExcl) {
        A.ensure(fromIncl >= 0, "fromIncl >= 0");
        A.ensure(toExcl >= 0, "toExcl >= 0");
        A.ensure(toExcl >= fromIncl, "toExcl > fromIncl");
        if (toExcl == fromIncl) {
            return Collections.emptyList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>(toExcl - fromIncl);
        for (int i = fromIncl; i < toExcl; ++i) {
            list.add(i);
        }
        return list;
    }

    public static String concat(Iterable<?> c, @Nullable String delim) {
        A.notNull(c, "c");
        StringConcatReducer f = new StringConcatReducer(delim);
        for (Object x : c) {
            if (!f.collect(x == null ? null : x.toString())) break;
        }
        return (String)f.reduce();
    }

    public static Collection<UUID> nodeIds(@Nullable Collection<? extends ClusterNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return F.viewReadOnly(nodes, GridFunc.node2id(), new IgnitePredicate[0]);
    }

    public static Collection<Object> nodeConsistentIds(@Nullable Collection<? extends BaselineNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return F.viewReadOnly(nodes, NODE2CONSISTENTID, new IgnitePredicate[0]);
    }

    public static <T> T rand(Collection<? extends T> c) {
        A.notNull(c, "c");
        int n = ThreadLocalRandom.current().nextInt(c.size());
        int i = 0;
        for (T t : c) {
            if (i++ != n) continue;
            return t;
        }
        throw new ConcurrentModificationException();
    }

    @Deprecated
    public static <T> T rand(List<T> l) {
        A.notNull(l, "l");
        return l.get(ThreadLocalRandom.current().nextInt(l.size()));
    }

    @Deprecated
    public static <T> T rand(T ... c) {
        A.notNull(c, "c");
        return c[ThreadLocalRandom.current().nextInt(c.length)];
    }

    public static <T> Collection<T> concat(boolean cp, @Nullable T t, @Nullable Collection<T> c) {
        if (cp) {
            if (GridFunc.isEmpty(c)) {
                ArrayList<T> l = new ArrayList<T>(1);
                l.add(t);
                return l;
            }
            ArrayList<T> ret = new ArrayList<T>(c.size() + 1);
            ret.add(t);
            ret.addAll(c);
            return ret;
        }
        if (GridFunc.isEmpty(c)) {
            return Collections.singletonList(t);
        }
        return new ReadOnlyCollectionView<T>(c, t);
    }

    public static <T> Collection<T> concat(boolean cp, @Nullable Collection<T> c1, @Nullable Collection<T> c2) {
        if (cp) {
            if (GridFunc.isEmpty(c1) && GridFunc.isEmpty(c2)) {
                return new ArrayList(0);
            }
            if (GridFunc.isEmpty(c1)) {
                return new ArrayList<T>(c2);
            }
            if (GridFunc.isEmpty(c2)) {
                return new ArrayList<T>(c1);
            }
            ArrayList<T> c = new ArrayList<T>(c1.size() + c2.size());
            c.addAll(c1);
            c.addAll(c2);
            return c;
        }
        if (GridFunc.isEmpty(c1) && GridFunc.isEmpty(c2)) {
            return Collections.emptyList();
        }
        if (GridFunc.isEmpty(c1) || GridFunc.isEmpty(c2)) {
            Collection<T> c;
            Collection<T> collection = c = GridFunc.isEmpty(c1) ? c2 : c1;
            assert (c != null);
            return c;
        }
        return new ReadOnlyCollectionView2X<T>(c1, c2);
    }

    public static <T> T[] concat(@Nullable T[] arr, T ... obj) {
        T[] newArr;
        if (arr == null || arr.length == 0) {
            newArr = obj;
        } else {
            newArr = Arrays.copyOf(arr, arr.length + obj.length);
            System.arraycopy(obj, 0, newArr, arr.length, obj.length);
        }
        return newArr;
    }

    public static <T> Iterator<T> concat(Iterator<T> ... iters) {
        if (iters.length == 1) {
            return iters[0];
        }
        return GridFunc.concat(GridFunc.asList(iters).iterator());
    }

    public static <T> Iterator<T> concat(Iterator<Iterator<T>> iters) {
        if (!iters.hasNext()) {
            return Collections.emptySet().iterator();
        }
        return new MultipleIterator<T>(iters);
    }

    public static <T0, T extends T0> Collection<T> lose(Collection<T> c, boolean cp, @Nullable Collection<T0> filter) {
        A.notNull(c, "c");
        return GridFunc.lose(c, cp, F0.in(filter));
    }

    @Deprecated
    public static <T> Collection<T> lose(Collection<T> c, boolean cp, IgnitePredicate<? super T> ... p) {
        Collection<T> res;
        block5: {
            block3: {
                block4: {
                    A.notNull(c, "c");
                    if (cp) break block3;
                    res = c;
                    if (!GridFunc.isEmpty(p)) break block4;
                    res.clear();
                    break block5;
                }
                if (GridFunc.isAlwaysFalse(p)) break block5;
                Iterator<T> iter = res.iterator();
                while (iter.hasNext()) {
                    if (!GridFunc.isAll(iter.next(), p)) continue;
                    iter.remove();
                }
                break block5;
            }
            res = new LinkedList<T>();
            if (!GridFunc.isEmpty(p) && !GridFunc.isAlwaysTrue(p)) {
                for (T t : c) {
                    if (GridFunc.isAll(t, p)) continue;
                    res.add(t);
                }
            }
        }
        return res;
    }

    @Deprecated
    public static <K, V> Map<K, V> lose(Map<K, V> m, boolean cp, IgnitePredicate<? super Map.Entry<K, V>> ... p) {
        Map<K, V> res;
        block5: {
            block3: {
                block4: {
                    A.notNull(m, "m");
                    if (cp) break block3;
                    res = m;
                    if (!GridFunc.isEmpty(p)) break block4;
                    res.clear();
                    break block5;
                }
                if (GridFunc.isAlwaysFalse(p)) break block5;
                Iterator<Map.Entry<K, V>> iter = m.entrySet().iterator();
                while (iter.hasNext()) {
                    if (!GridFunc.isAll(iter.next(), p)) continue;
                    iter.remove();
                }
                break block5;
            }
            res = U.newHashMap(m.size());
            if (!GridFunc.isEmpty(p) && !GridFunc.isAlwaysTrue(p)) {
                for (Map.Entry<K, V> e : m.entrySet()) {
                    if (F.isAll(e, p)) continue;
                    res.put(e.getKey(), e.getValue());
                }
            }
        }
        return res;
    }

    public static <T> List<T> loseList(List<T> c, boolean cp, @Nullable Collection<? super T> filter) {
        List<T> res;
        A.notNull(c, "c");
        if (!cp) {
            res = c;
            if (filter != null) {
                res.removeAll(filter);
            }
        } else {
            res = new LinkedList<T>();
            for (T t : c) {
                if (filter != null && filter.contains(t)) continue;
                res.add(t);
            }
        }
        return res;
    }

    @Deprecated
    public static <T> List<T> filterList(List<T> c, boolean cp, IgnitePredicate<T> ... p) {
        List<T> res;
        block3: {
            block2: {
                A.notNull(c, "c");
                if (cp) break block2;
                res = c;
                if (p == null) break block3;
                Iterator<T> it = c.iterator();
                while (it.hasNext()) {
                    if (!GridFunc.isAny(it.next(), p)) continue;
                    it.remove();
                }
                break block3;
            }
            res = new ArrayList<T>(c.size());
            for (T t : c) {
                if (GridFunc.isAny(t, p)) continue;
                res.add(t);
            }
        }
        return res;
    }

    public static IgniteClosure<ClusterNode, UUID> node2id() {
        return NODE2ID;
    }

    public static <T extends ClusterNode> IgnitePredicate<T> nodeForNodeId(UUID nodeId) {
        A.notNull(nodeId, "nodeId");
        return new EqualsClusterNodeIdPredicate(nodeId);
    }

    public static <T extends ClusterNode> IgnitePredicate<T> nodeForNodeIds(@Nullable Collection<UUID> nodeIds) {
        if (GridFunc.isEmpty(nodeIds)) {
            return GridFunc.alwaysFalse();
        }
        return new ContainsNodeIdsPredicate(nodeIds);
    }

    public static IgnitePredicate<UUID> idForNodeId(UUID nodeId) {
        A.notNull(nodeId, "nodeId");
        return new EqualsUuidPredicate(nodeId);
    }

    public static IgnitePredicate<ClusterNode> nodeForNodes(ClusterNode ... nodes) {
        return new GridNodePredicate(nodes);
    }

    @Deprecated
    public static <T0, T extends T0> Collection<T> retain(Collection<T> c, boolean cp, @Nullable Collection<? extends T0> filter) {
        A.notNull(c, "c");
        return GridFunc.retain(c, cp, F0.in(filter));
    }

    public static <T> Collection<T> retain(Collection<T> c, boolean cp, IgnitePredicate<? super T> ... p) {
        A.notNull(c, "c");
        return GridFunc.lose(c, cp, GridFunc.not(p));
    }

    public static <T> Collection<T> retain(Collection<T> c, boolean cp, int num) {
        Collection<T> res;
        block3: {
            block2: {
                A.notNull(c, "c");
                A.ensure(num >= 0, "num >= 0");
                if (cp) break block2;
                res = c;
                if (num >= res.size()) break block3;
                int i = 0;
                Iterator<T> iter = res.iterator();
                while (iter.hasNext()) {
                    iter.next();
                    if (i++ < num) continue;
                    iter.remove();
                }
                break block3;
            }
            res = new ArrayList<T>(num);
            Iterator<T> iter = c.iterator();
            for (int i = 0; i < num && iter.hasNext(); ++i) {
                res.add(iter.next());
            }
        }
        return res;
    }

    public static <T> List<T> asList(T ... vals) {
        return GridFunc.isEmpty(vals) ? Collections.emptyList() : Arrays.asList(vals);
    }

    @Deprecated
    public static <T> GridIterator<T> emptyIterator() {
        return new GridEmptyIterator();
    }

    public static <T> Collection<T> flatCollections(@Nullable Collection<? extends Collection<T>> c) {
        if (F.isEmpty(c)) {
            return Collections.emptyList();
        }
        return new FlatCollectionWrapper(c);
    }

    public static <T> GridIterator<T> flat(@Nullable Iterable<? extends Iterable<T>> c) {
        return GridFunc.isEmpty(c) ? GridFunc.emptyIterator() : new FlatIterator(c);
    }

    public static <T> Iterator<T> flatIterators(@Nullable Iterable<Iterator<T>> c) {
        return GridFunc.isEmpty(c) ? GridFunc.emptyIterator() : new FlatIterator(c);
    }

    @Deprecated
    public static GridAbsClosure as(@Nullable Runnable r) {
        return new RunnableWrapperClosure(r);
    }

    public static <T> int size(@Nullable Collection<? extends T> c, IgnitePredicate<? super T> ... p) {
        return c == null || c.isEmpty() ? 0 : (GridFunc.isEmpty(p) || GridFunc.isAlwaysTrue(p) ? c.size() : GridFunc.size(c.iterator(), p));
    }

    public static <T> int size(@Nullable Iterator<? extends T> it, IgnitePredicate<? super T> ... p) {
        if (it == null) {
            return 0;
        }
        int n = 0;
        if (!GridFunc.isAlwaysFalse(p)) {
            while (it.hasNext()) {
                if (!GridFunc.isAll(it.next(), p)) continue;
                ++n;
            }
        }
        return n;
    }

    @SafeVarargs
    public static <T> Collection<T> view(@Nullable Collection<T> c, IgnitePredicate<? super T> ... p) {
        if (GridFunc.isEmpty(c) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyList();
        }
        return GridFunc.isEmpty(p) || GridFunc.isAlwaysTrue(p) ? c : new PredicateCollectionView<T>(c, p);
    }

    @SafeVarargs
    public static <T1, T2> Collection<T2> viewReadOnly(@Nullable Collection<? extends T1> c, IgniteClosure<? super T1, T2> trans, IgnitePredicate<? super T1> ... p) {
        A.notNull(trans, "trans");
        if (GridFunc.isEmpty(c) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyList();
        }
        return new TransformCollectionView<T2, T1>(c, trans, p);
    }

    @Deprecated
    public static <T1, T2> List<T2> transformList(Collection<? extends T1> c, IgniteClosure<? super T1, T2> trans, IgnitePredicate<? super T1> ... p) {
        A.notNull(c, "c", trans, "trans");
        if (GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyList();
        }
        return new ArrayList<T2>(GridFunc.transform(GridFunc.retain(c, true, p), trans));
    }

    public static <K0, K extends K0, V0, V extends V0> Map<K, V> view(@Nullable Map<K, V> m, IgnitePredicate<? super K> ... p) {
        if (GridFunc.isEmpty(m) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyMap();
        }
        return GridFunc.isEmpty(p) || GridFunc.isAlwaysTrue(p) ? m : new PredicateMapView(m, p);
    }

    public static <K0, K extends K0, V0, V extends V0, V1> Map<K, V1> viewReadOnly(@Nullable Map<K, V> m, IgniteClosure<V, V1> trans, IgnitePredicate<? super K> ... p) {
        A.notNull(trans, "trans");
        if (GridFunc.isEmpty(m) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyMap();
        }
        return new TransformMapView<K, V1, V>(m, trans, p);
    }

    @Deprecated
    public static <K0, K extends K0, V0, V extends V0, V1> Map<K, V1> viewReadOnly(@Nullable Map<K, V> m, IgniteBiClosure<K, V, V1> trans, IgnitePredicate<? super K> ... p) {
        A.notNull(trans, "trans");
        if (GridFunc.isEmpty(m) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyMap();
        }
        return new TransformMapView2<K, V, V1>(m, trans, p);
    }

    public static <K0, K extends K0, V0, V extends V0> Map<K, V> viewAsMap(@Nullable Set<K> c, IgniteClosure<? super K, V> mapClo, IgnitePredicate<? super K> ... p) {
        A.notNull(mapClo, "trans");
        if (GridFunc.isEmpty(c) || GridFunc.isAlwaysFalse(p)) {
            return Collections.emptyMap();
        }
        return new PredicateSetView<K, V>(c, mapClo, p);
    }

    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static <T> boolean isEmpty(@Nullable T[] c) {
        return c == null || c.length == 0;
    }

    public static <T> boolean isEmptyOrNulls(@Nullable T[] c) {
        if (GridFunc.isEmpty(c)) {
            return true;
        }
        for (T element : c) {
            if (element == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(@Nullable int[] c) {
        return c == null || c.length == 0;
    }

    public static boolean isEmpty(@Nullable byte[] c) {
        return c == null || c.length == 0;
    }

    public static boolean isEmpty(@Nullable long[] c) {
        return c == null || c.length == 0;
    }

    public static boolean isEmpty(@Nullable Iterable<?> c) {
        return c == null || (c instanceof Collection ? ((Collection)c).isEmpty() : !c.iterator().hasNext());
    }

    public static boolean isEmpty(@Nullable Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEmptyDirectory(Path dir) {
        if (dir == null) return false;
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> files = Files.newDirectoryStream(dir);){
            boolean bl = !files.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isNotEmptyDirectory(Path dir) {
        if (dir == null) return false;
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> files = Files.newDirectoryStream(dir);){
            boolean bl = files.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    @Deprecated
    public static IgniteCallable<AtomicInteger> newAtomicInt() {
        return ATOMIC_INT_FACTORY;
    }

    public static <T> IgniteCallable<Set<T>> newSet() {
        return SET_FACTORY;
    }

    @Deprecated
    public static <K, V> IgniteCallable<Map<K, V>> newMap() {
        return MAP_FACTORY;
    }

    public static <K, V> IgniteCallable<ConcurrentMap<K, V>> newCMap() {
        return CONCURRENT_MAP_FACTORY;
    }

    public static <E> IgniteCallable<Set<E>> newCSet() {
        return CONCURRENT_SET_FACTORY;
    }

    public static <T> GridIterator<T> iterator0(Iterable<? extends T> c, boolean readOnly, IgnitePredicate<? super T> ... p) {
        return F.iterator(c, IDENTITY, readOnly, p);
    }

    public static <T1, T2> GridIterator<T2> iterator(Iterable<? extends T1> c, IgniteClosure<? super T1, T2> trans, boolean readOnly, IgnitePredicate<? super T1> ... p) {
        A.notNull(c, "c", trans, "trans");
        if (GridFunc.isAlwaysFalse(p)) {
            return F.emptyIterator();
        }
        return new TransformFilteringIterator<T2, T1>(c.iterator(), trans, readOnly, p);
    }

    @SafeVarargs
    public static <T1, T2> Iterator<T2> iterator(Iterator<? extends T1> c, IgniteClosure<? super T1, T2> trans, boolean readOnly, IgnitePredicate<? super T1> ... p) {
        A.notNull(c, "c", trans, "trans");
        if (GridFunc.isAlwaysFalse(p)) {
            return F.emptyIterator();
        }
        return new TransformFilteringIterator<T2, T1>(c, trans, readOnly, p);
    }

    public static <T> IgnitePredicate<T> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static <T> IgnitePredicate<T> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    @Deprecated
    public static boolean isAlwaysTrue(IgnitePredicate p) {
        return p == ALWAYS_TRUE;
    }

    public static boolean isAlwaysTrue(@Nullable IgnitePredicate[] p) {
        return p != null && p.length == 1 && GridFunc.isAlwaysTrue(p[0]);
    }

    @Deprecated
    public static boolean isAlwaysFalse(IgnitePredicate p) {
        return p == ALWAYS_FALSE;
    }

    @Deprecated
    public static boolean isAlwaysFalse(@Nullable IgnitePredicate[] p) {
        return p != null && p.length == 1 && GridFunc.isAlwaysFalse(p[0]);
    }

    public static <T> IgnitePredicate<T> notNull() {
        return IS_NOT_NULL;
    }

    @SafeVarargs
    public static <T> IgnitePredicate<T> not(IgnitePredicate<? super T> ... p) {
        return GridFunc.isAlwaysFalse(p) ? F.alwaysTrue() : (GridFunc.isAlwaysTrue(p) ? F.alwaysFalse() : new IsNotAllPredicate<T>(p));
    }

    @Deprecated
    public static <T> IgnitePredicate<T> equalTo(@Nullable T target) {
        return new NotEqualPredicate<T>(target);
    }

    public static <T> IgnitePredicate<T> notEqualTo(@Nullable T target) {
        return new NotEqualPredicate<T>(target);
    }

    public static <T> T first(@Nullable Iterable<? extends T> c) {
        if (c == null) {
            return null;
        }
        if (c instanceof List) {
            return GridFunc.first((List)c);
        }
        Iterator<T> it = c.iterator();
        return it.hasNext() ? (T)it.next() : null;
    }

    public static <T> T first(List<? extends T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Deprecated
    @Nullable
    public static <T> T last(@Nullable Iterable<? extends T> c) {
        if (c == null) {
            return null;
        }
        if (c instanceof RandomAccess && c instanceof List) {
            List l = (List)c;
            return (T)l.get(l.size() - 1);
        }
        if (c instanceof NavigableSet) {
            NavigableSet s = (NavigableSet)c;
            return (T)s.last();
        }
        T last = null;
        for (T t : c) {
            last = t;
        }
        return last;
    }

    @Nullable
    public static <V> V firstValue(Map<?, V> m) {
        Iterator<V> it = m.values().iterator();
        return it.hasNext() ? (V)it.next() : null;
    }

    @Deprecated
    @Nullable
    public static <K> K firstKey(Map<K, ?> m) {
        Iterator<K> it = m.keySet().iterator();
        return it.hasNext() ? (K)it.next() : null;
    }

    @Nullable
    public static <K, V> Map.Entry<K, V> firstEntry(Map<K, V> m) {
        Iterator<Map.Entry<K, V>> it = m.entrySet().iterator();
        return it.hasNext() ? it.next() : null;
    }

    public static <T> IgnitePredicate<T> and(IgnitePredicate<? super T> ... ps) {
        if (GridFunc.isEmpty(ps)) {
            return F.alwaysTrue();
        }
        if (GridFunc.isAlwaysFalse(ps)) {
            return F.alwaysFalse();
        }
        if (GridFunc.isAlwaysTrue(ps)) {
            return F.alwaysTrue();
        }
        if (F0.isAllNodePredicates(ps)) {
            HashSet<UUID> ids = new HashSet<UUID>();
            for (IgnitePredicate<T> ignitePredicate : ps) {
                if (ignitePredicate == null) continue;
                Set<UUID> list = ((GridNodePredicate)ignitePredicate).nodeIds();
                if (ids.isEmpty()) {
                    ids.addAll(list);
                    continue;
                }
                ids.retainAll(list);
            }
            return new GridNodePredicate((Set<UUID>)ids);
        }
        return new IsAllPredicate<T>(ps);
    }

    public static <T> IgniteClosure<T, T> identity() {
        return IDENTITY;
    }

    @Deprecated
    public static <T> IgniteClosure<T, String> string() {
        return new ToStringClosure();
    }

    public static <T> IgnitePredicate<T> notIn(@Nullable Collection<? extends T> c) {
        return GridFunc.isEmpty(c) ? GridFunc.alwaysTrue() : new NotContainsPredicate<T>(c);
    }

    @Deprecated
    public static <T, C extends Collection<T>> C addAll(C c, Iterable<? extends T> it) {
        if (it == null) {
            return c;
        }
        if (it instanceof Collection) {
            c.addAll((Collection)it);
            return c;
        }
        return GridFunc.addAll(c, it.iterator());
    }

    @Deprecated
    public static <T, C extends Collection<T>> C addAll(C c, Iterator<? extends T> it) {
        if (it != null) {
            while (it.hasNext()) {
                c.add(it.next());
            }
        }
        return c;
    }

    public static <K, V> V addIfAbsent(ConcurrentMap<K, V> map, K key, @Nullable Callable<V> c) {
        A.notNull(map, "map", key, "key");
        Object v = map.get(key);
        if (v == null && c != null) {
            try {
                v = c.call();
            }
            catch (Exception e) {
                throw F.wrap(e);
            }
            V v0 = map.putIfAbsent(key, v);
            if (v0 != null) {
                v = v0;
            }
        }
        return v;
    }

    public static <K, V> V addIfAbsent(ConcurrentMap<K, V> map, K key, V val) {
        A.notNull(map, "map", key, "key", val, "val");
        V v = map.putIfAbsent(key, val);
        if (v != null) {
            val = v;
        }
        return val;
    }

    @Nullable
    public static <K, V> V addIfAbsent(Map<? super K, V> map, @Nullable K key, @Nullable Callable<? extends V> c) {
        A.notNull(map, "map");
        try {
            if (!map.containsKey(key)) {
                V v = c == null ? null : (V)c.call();
                map.put(key, v);
                return v;
            }
            return map.get(key);
        }
        catch (Exception e) {
            throw GridFunc.wrap(e);
        }
    }

    @Nullable
    public static <K, V> V addIfAbsent(Map<K, V> map, @Nullable K key, @Nullable V v) {
        A.notNull(map, "map");
        try {
            if (!map.containsKey(key)) {
                map.put(key, v);
                return v;
            }
            return map.get(key);
        }
        catch (Exception e) {
            throw GridFunc.wrap(e);
        }
    }

    @Deprecated
    public static <X> void forEach(Iterable<? extends X> c, IgniteInClosure<? super X> f, IgnitePredicate<? super X> ... p) {
        A.notNull(c, "c", f, "f");
        for (X x : c) {
            if (!GridFunc.isAll(x, p)) continue;
            f.apply(x);
        }
    }

    @Deprecated
    public static <X> void forEach(X[] c, IgniteInClosure<? super X> f, IgnitePredicate<? super X> ... p) {
        A.notNull(c, "c", f, "f");
        F.forEach(GridFunc.asList(c), f, p);
    }

    @Deprecated
    public static <T> Collection<T> copy(Collection<T> to, T ... from) {
        A.notNull(to, "to", from, "from");
        GridFunc.copy(to, GridFunc.asList(from), new IgnitePredicate[0]);
        return to;
    }

    @Deprecated
    public static <T> Collection<T> copy(Collection<T> to, Iterable<? extends T> from, IgnitePredicate<? super T> ... p) {
        A.notNull(to, "to", from, "from");
        if (!GridFunc.isAlwaysFalse(p)) {
            for (T t : from) {
                if (!GridFunc.isAll(t, p)) continue;
                to.add(t);
            }
        }
        return to;
    }

    public static <X, Y> Collection<Y> transform(Collection<? extends X> c, IgniteClosure<? super X, Y> f) {
        A.notNull(c, "c", f, "f");
        ArrayList<Y> d = new ArrayList<Y>(c.size());
        for (X x : c) {
            d.add(f.apply(x));
        }
        return d;
    }

    @Deprecated
    public static <X, Y> Collection<Y> transform(X[] c, IgniteClosure<? super X, Y> f) {
        A.notNull(c, "c", f, "f");
        return GridFunc.viewReadOnly(GridFunc.asList(c), f, new IgnitePredicate[0]);
    }

    public static <T> boolean isAll(@Nullable T t, IgnitePredicate<? super T> ... p) {
        if (p != null) {
            for (IgnitePredicate<T> ignitePredicate : p) {
                if (ignitePredicate == null || ignitePredicate.apply(t)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static <T> boolean isAny(@Nullable T t, IgnitePredicate<? super T> ... p) {
        if (p != null) {
            for (IgnitePredicate<T> ignitePredicate : p) {
                if (ignitePredicate == null || !ignitePredicate.apply(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static GridAbsClosure noop() {
        return NOOP;
    }

    @SafeVarargs
    @Nullable
    public static <V> V find(Iterable<? extends V> c, @Nullable V dfltVal, IgnitePredicate<? super V> ... p) {
        A.notNull(c, "c");
        if (!GridFunc.isEmpty(p) && !GridFunc.isAlwaysFalse(p)) {
            for (V v : c) {
                if (!GridFunc.isAny(v, p)) continue;
                return v;
            }
        }
        return dfltVal;
    }

    @Deprecated
    public static <V, Y> Y find(Iterable<? extends V> c, @Nullable Y dfltVal, IgniteClosure<? super V, Y> f, IgnitePredicate<? super V> ... p) {
        A.notNull(c, "c", f, "f");
        if (GridFunc.isAlwaysTrue(p) && c.iterator().hasNext()) {
            return f.apply(c.iterator().next());
        }
        if (!GridFunc.isEmpty(p) && !GridFunc.isAlwaysFalse(p)) {
            for (V v : c) {
                if (!GridFunc.isAny(v, p)) continue;
                return f.apply(v);
            }
        }
        return dfltVal;
    }

    @Deprecated
    public static <T> boolean containsAny(@Nullable Collection<? extends T> c1, @Nullable Iterable<? extends T> c2) {
        if (c1 != null && !c1.isEmpty() && c2 != null && c2.iterator().hasNext()) {
            for (T t : c2) {
                if (!c1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean containsAny(@Nullable Collection<? extends T> c1, T ... c2) {
        if (c1 != null && !c1.isEmpty() && c2 != null && c2.length > 0) {
            for (T t : c2) {
                if (!c1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static <T> boolean containsAll(@Nullable Collection<? extends T> c1, @Nullable Iterable<? extends T> c2) {
        if (c1 == null) {
            return false;
        }
        if (c2 != null) {
            for (T t : c2) {
                if (c1.contains(t)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static <T> IgnitePair<T> pair(@Nullable T t1, @Nullable T t2) {
        return new IgnitePair<T>(t1, t2);
    }

    @Deprecated
    public static <V> IgniteBiTuple<Collection<V>, Collection<V>> partition(Iterable<? extends V> c, IgnitePredicate<? super V> p) {
        A.notNull(c, "c", p, "p");
        LinkedList<V> c1 = new LinkedList<V>();
        LinkedList<V> c2 = new LinkedList<V>();
        for (V v : c) {
            if (p.apply(v)) {
                c1.add(v);
                continue;
            }
            c2.add(v);
        }
        return GridFunc.t(c1, c2);
    }

    public static <V> boolean exist(Iterable<? extends V> c, IgnitePredicate<? super V> ... p) {
        A.notNull(c, "c");
        if (GridFunc.isAlwaysFalse(p)) {
            return false;
        }
        if (GridFunc.isAlwaysTrue(p)) {
            return true;
        }
        if (GridFunc.isEmpty(p)) {
            return true;
        }
        for (V v : c) {
            if (!GridFunc.isAll(v, p)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static <V> boolean forAll(Iterable<? extends V> c, IgnitePredicate<? super V> ... p) {
        A.notNull(c, "c");
        if (GridFunc.isAlwaysFalse(p)) {
            return false;
        }
        if (GridFunc.isAlwaysTrue(p)) {
            return true;
        }
        if (!GridFunc.isEmpty(p)) {
            for (V v : c) {
                if (GridFunc.isAll(v, p)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static <K1, K extends K1, V1, V extends V1> boolean forAll(Map<K, V> m, IgnitePredicate<? super Map.Entry<K, V>> ... p) {
        A.notNull(m, "m");
        if (GridFunc.isAlwaysFalse(p)) {
            return false;
        }
        if (GridFunc.isAlwaysTrue(p)) {
            return true;
        }
        if (!GridFunc.isEmpty(p)) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                if (GridFunc.isAll(e, p)) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static <V> boolean forAny(Iterable<? extends V> c, IgnitePredicate<? super V> ... p) {
        A.notNull(c, "c");
        if (!c.iterator().hasNext()) {
            return false;
        }
        if (GridFunc.isEmpty(p)) {
            return true;
        }
        if (GridFunc.isAlwaysFalse(p)) {
            return false;
        }
        if (GridFunc.isAlwaysTrue(p)) {
            return true;
        }
        for (V v : c) {
            if (!GridFunc.isAll(v, p)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    @Nullable
    public static <D, B> B fold(Iterable<? extends D> c, @Nullable B b, IgniteBiClosure<? super D, ? super B, B> ... fs) {
        A.notNull(c, "c");
        if (!GridFunc.isEmpty(fs)) {
            for (D e : c) {
                for (IgniteBiClosure<D, B, B> igniteBiClosure : fs) {
                    b = igniteBiClosure.apply(e, b);
                }
            }
        }
        return b;
    }

    public static <V> GridTuple<V> t(@Nullable V v) {
        return new GridTuple<V>(v);
    }

    @Deprecated
    public static <V> GridTuple<V> t1() {
        return new GridTuple();
    }

    public static <V1, V2> IgniteBiTuple<V1, V2> t(@Nullable V1 v1, @Nullable V2 v2) {
        return new IgniteBiTuple<V1, V2>(v1, v2);
    }

    @Deprecated
    public static <V1, V2> IgniteBiTuple<V1, V2> t2() {
        return new IgniteBiTuple();
    }

    public static <V1, V2, V3> GridTuple3<V1, V2, V3> t(@Nullable V1 v1, @Nullable V2 v2, @Nullable V3 v3) {
        return new GridTuple3<V1, V2, V3>(v1, v2, v3);
    }

    @Deprecated
    public static <V1, V2, V3, V4> GridTuple4<V1, V2, V3, V4> t(@Nullable V1 v1, @Nullable V2 v2, @Nullable V3 v3, @Nullable V4 v4) {
        return new GridTuple4<V1, V2, V3, V4>(v1, v2, v3, v4);
    }

    @Deprecated
    public static <V1, V2, V3, V4, V5> GridTuple5<V1, V2, V3, V4, V5> t(@Nullable V1 v1, @Nullable V2 v2, @Nullable V3 v3, @Nullable V4 v4, @Nullable V5 v5) {
        return new GridTuple5<V1, V2, V3, V4, V5>(v1, v2, v3, v4, v5);
    }

    @Deprecated
    public static <V1, V2, V3, V4, V5, V6> GridTuple6<V1, V2, V3, V4, V5, V6> t(@Nullable V1 v1, @Nullable V2 v2, @Nullable V3 v3, @Nullable V4 v4, @Nullable V5 v5, @Nullable V6 v6) {
        return new GridTuple6<V1, V2, V3, V4, V5, V6>(v1, v2, v3, v4, v5, v6);
    }

    @Deprecated
    public static <V1, V2, V3> GridTuple3<V1, V2, V3> t3() {
        return new GridTuple3();
    }

    @Deprecated
    public static <V1, V2, V3, V4> GridTuple4<V1, V2, V3, V4> t4() {
        return new GridTuple4();
    }

    @Deprecated
    public static <V1, V2, V3, V4, V5> GridTuple5<V1, V2, V3, V4, V5> t5() {
        return new GridTuple5();
    }

    @Deprecated
    public static <V1, V2, V3, V4, V5, V6> GridTuple6<V1, V2, V3, V4, V5, V6> t6() {
        return new GridTuple6();
    }

    @Deprecated
    public static <K, V> Map<K, V> zip(Collection<? extends K> keys, V dfltVal) {
        A.notNull(keys, "keys");
        HashMap<K, V> m = new HashMap<K, V>(keys.size(), 1.0f);
        for (K k : keys) {
            m.put(k, dfltVal);
        }
        return m;
    }

    public static <K, V> Map<K, V> asMap(K k, V v) {
        GridLeanMap<K, V> map = new GridLeanMap<K, V>(1);
        map.put(k, v);
        return map;
    }

    public static <K, V> Map<K, V> asMap(K k1, V v1, K k2, V v2) {
        GridLeanMap<K, V> map = new GridLeanMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    @Deprecated
    public static <K, V> Map<K, V> asMap(K k1, V v1, K k2, V v2, K k3, V v3) {
        GridLeanMap<K, V> map = new GridLeanMap<K, V>(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    @Deprecated
    public static <K, V> Map<K, V> asMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        GridLeanMap<K, V> map = new GridLeanMap<K, V>(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    @Deprecated
    public static <K, V> Map<K, V> asMap(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        GridLeanMap<K, V> map = new GridLeanMap<K, V>(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <T> T[] asArray(T ... t) {
        return t;
    }

    public static <T> List<T> asList(@Nullable T t) {
        return t == null ? Collections.emptyList() : Collections.singletonList(t);
    }

    @Deprecated
    public static <T> Set<T> asSet(@Nullable T t) {
        return t == null ? Collections.emptySet() : Collections.singleton(t);
    }

    @Deprecated
    public static <T> Set<T> asSet(T ... t) {
        if (t == null || t.length == 0) {
            return Collections.emptySet();
        }
        if (t.length == 1) {
            return Collections.singleton(t[0]);
        }
        return new GridLeanSet<T[]>(GridFunc.asList(t));
    }

    public static <T> boolean contains(@Nullable Collection<T> c, @Nullable T t) {
        return c != null && c.contains(t);
    }

    public static <T> IgnitePredicate<T> contains(@Nullable Collection<T> c) {
        return c == null || c.isEmpty() ? GridFunc.alwaysFalse() : new ContainsPredicate<T>(c);
    }

    public static <T> IgnitePredicate<T> notContains(@Nullable Collection<T> c) {
        return c == null || c.isEmpty() ? GridFunc.alwaysTrue() : new NotContainsPredicate<T>(c);
    }

    public static boolean contains(int[] arr, int val) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean constainsStringIgnoreCase(@Nullable Collection<String> col, String val) {
        if (F.isEmpty(col)) {
            return false;
        }
        for (String v : col) {
            if (!v.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    public static boolean constainsStringIgnoreCase(@Nullable String[] arr, String val) {
        if (F.isEmpty(arr)) {
            return false;
        }
        for (String v : arr) {
            if (!v.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean contains(Integer[] arr, int val) {
        for (Integer el : arr) {
            if (el != val) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean contains(long[] arr, long val) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean eq(@Nullable Object o1, @Nullable Object o2) {
        return o1 == null ? o2 == null : o2 != null && (o1 == o2 || o1.equals(o2));
    }

    @Deprecated
    public static boolean eqOrdered(@Nullable Collection<?> c1, @Nullable Collection<?> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        Iterator<?> it1 = c1.iterator();
        Iterator<?> it2 = c2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (GridFunc.eq(it1.next(), it2.next())) continue;
            return false;
        }
        return it1.hasNext() == it2.hasNext();
    }

    public static boolean eqNotOrdered(@Nullable Collection<?> c1, @Nullable Collection<?> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1 instanceof RandomAccess || c2 instanceof RandomAccess) {
            List lst;
            Collection<?> col;
            if (c1 instanceof RandomAccess) {
                col = c2;
                lst = (List)c1;
            } else {
                col = c1;
                lst = (List)c2;
            }
            int p = 0;
            int size = c1.size();
            for (Object o1 : col) {
                boolean found = false;
                for (int i = p; i < size; ++i) {
                    if (!F.eq(lst.get(i), o1)) continue;
                    found = true;
                    if (i != p) break;
                    ++p;
                    break;
                }
                if (found) continue;
                return false;
            }
        } else if (c1 instanceof Set && c2 instanceof Set) {
            for (Object o : c1) {
                if (c2.contains(o)) continue;
                return false;
            }
        } else {
            for (Object o : c1) {
                if (c2.contains(o)) continue;
                return false;
            }
            for (Object o : c2) {
                if (c1.contains(o)) continue;
                return false;
            }
        }
        return true;
    }

    public static <K, V> boolean eqNotOrdered(@Nullable Map<K, V> m1, @Nullable Map<K, V> m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry<K, V> e : m1.entrySet()) {
            V v2;
            V v1 = e.getValue();
            if (v1 == (v2 = m2.get(e.getKey()))) {
                return true;
            }
            if (v1 == null || v2 == null) {
                return false;
            }
            if (!(v1 instanceof Collection && v2 instanceof Collection ? !GridFunc.eqNotOrdered((Collection)v1, (Collection)v2) : (v1 instanceof Map && v2 instanceof Map ? !GridFunc.eqNotOrdered((Map)v1, (Map)v2) : !GridFunc.eq(v1, v2)))) continue;
            return false;
        }
        return true;
    }

    public static boolean eqNodes(Object n1, Object n2) {
        return n1 == n2 || n1 != null && n2 != null && n1 instanceof ClusterNode && n2 instanceof ClusterNode && ((ClusterNode)n1).id().equals(((ClusterNode)n2).id());
    }

    public static <K, V> IgniteClosure<Cache.Entry<K, V>, V> cacheEntry2Get() {
        return CACHE_ENTRY_VAL_GET;
    }

    public static <K, V> IgnitePredicate<Cache.Entry<K, V>> cacheHasPeekValue() {
        return CACHE_ENTRY_HAS_PEEK_VAL;
    }

    public static GridClosureException wrap(Throwable e) {
        return new GridClosureException(e);
    }

    @Deprecated
    public static <T> void awaitAll(@Nullable Collection<IgniteInternalFuture<T>> futs) throws IgniteCheckedException {
        GridFunc.awaitAll(0L, null, futs);
    }

    @Deprecated
    public static <T> void awaitAll(long timeout, @Nullable Collection<IgniteInternalFuture<T>> futs) throws IgniteCheckedException {
        GridFunc.awaitAll(timeout, null, futs);
    }

    @Deprecated
    @Nullable
    public static <T, R> R awaitAll(long timeout, @Nullable IgniteReducer<T, R> rdc, @Nullable Collection<IgniteInternalFuture<T>> futs) throws IgniteCheckedException {
        long end;
        if (futs == null || futs.isEmpty()) {
            return null;
        }
        long l = end = timeout == 0L ? Long.MAX_VALUE : U.currentTimeMillis() + timeout;
        if (end < 0L) {
            end = Long.MAX_VALUE;
        }
        for (IgniteInternalFuture<T> fut : futs) {
            T t;
            if (timeout > 0L) {
                long left = end - U.currentTimeMillis();
                if (left <= 0L && !fut.isDone()) {
                    throw new IgniteFutureTimeoutCheckedException("Timed out waiting for all futures: " + futs);
                }
                if (fut.isDone() && left < 0L) {
                    left = 0L;
                }
                t = fut.get(left);
            } else {
                t = fut.get();
            }
            if (rdc == null) continue;
            rdc.collect(t);
        }
        return rdc == null ? null : (R)rdc.reduce();
    }

    public static boolean isSorted(long[] arr) {
        if (GridFunc.isEmpty(arr) || arr.length == 1) {
            return true;
        }
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i - 1] <= arr[i]) continue;
            return false;
        }
        return true;
    }

    public static BooleanSupplier nonThrowableSupplier(BooleanSupplier s, IgniteLogger log) {
        return GridFunc.nonThrowableSupplier(s, false, log);
    }

    public static DoubleSupplier nonThrowableSupplier(DoubleSupplier s, IgniteLogger log) {
        return GridFunc.nonThrowableSupplier(s, 0.0, log);
    }

    public static IntSupplier nonThrowableSupplier(IntSupplier s, IgniteLogger log) {
        return GridFunc.nonThrowableSupplier(s, 0, log);
    }

    public static LongSupplier nonThrowableSupplier(LongSupplier s, IgniteLogger log) {
        return GridFunc.nonThrowableSupplier(s, 0L, log);
    }

    public static <T> Supplier<T> nonThrowableSupplier(Supplier<T> s, IgniteLogger log) {
        return GridFunc.nonThrowableSupplier(s, null, log);
    }

    public static BooleanSupplier nonThrowableSupplier(BooleanSupplier s, boolean dfltVal, IgniteLogger log) {
        return () -> {
            try {
                return s.getAsBoolean();
            }
            catch (Exception e) {
                LT.warn(log, e, "Exception in supplier", false, true);
                return dfltVal;
            }
        };
    }

    public static DoubleSupplier nonThrowableSupplier(DoubleSupplier s, double dfltVal, IgniteLogger log) {
        return () -> {
            try {
                return s.getAsDouble();
            }
            catch (Exception e) {
                LT.warn(log, e, "Exception in supplier", false, true);
                return dfltVal;
            }
        };
    }

    public static IntSupplier nonThrowableSupplier(IntSupplier s, int dfltVal, IgniteLogger log) {
        return () -> {
            try {
                return s.getAsInt();
            }
            catch (Exception e) {
                LT.warn(log, e, "Exception in supplier", false, true);
                return dfltVal;
            }
        };
    }

    public static LongSupplier nonThrowableSupplier(LongSupplier s, long dfltVal, IgniteLogger log) {
        return () -> {
            try {
                return s.getAsLong();
            }
            catch (Exception e) {
                LT.warn(log, e, "Exception in supplier", false, true);
                return dfltVal;
            }
        };
    }

    public static <T> Supplier<T> nonThrowableSupplier(Supplier<T> s, T dfltVal, IgniteLogger log) {
        return () -> {
            try {
                return s.get();
            }
            catch (Exception e) {
                LT.warn(log, e, "Exception in supplier", false, true);
                return dfltVal;
            }
        };
    }
}

