/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.ThinClientConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.authentication.AuthorizationContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerAbstractConnectionContext;
import org.apache.ignite.internal.processors.odbc.ClientListenerMessageParser;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.ClientListenerRequestHandler;
import org.apache.ignite.internal.processors.platform.client.ClientAffinityTopologyVersion;
import org.apache.ignite.internal.processors.platform.client.ClientMessageParser;
import org.apache.ignite.internal.processors.platform.client.ClientRequestHandler;
import org.apache.ignite.internal.processors.platform.client.ClientResourceRegistry;
import org.apache.ignite.internal.processors.platform.client.IgniteClientException;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxContext;

public class ClientConnectionContext
extends ClientListenerAbstractConnectionContext {
    public static final ClientListenerProtocolVersion VER_1_0_0 = ClientListenerProtocolVersion.create(1, 0, 0);
    public static final ClientListenerProtocolVersion VER_1_1_0 = ClientListenerProtocolVersion.create(1, 1, 0);
    public static final ClientListenerProtocolVersion VER_1_2_0 = ClientListenerProtocolVersion.create(1, 2, 0);
    public static final ClientListenerProtocolVersion VER_1_3_0 = ClientListenerProtocolVersion.create(1, 3, 0);
    public static final ClientListenerProtocolVersion VER_1_4_0 = ClientListenerProtocolVersion.create(1, 4, 0);
    public static final ClientListenerProtocolVersion VER_1_5_0 = ClientListenerProtocolVersion.create(1, 5, 0);
    public static final ClientListenerProtocolVersion VER_1_6_0;
    public static final ClientListenerProtocolVersion DEFAULT_VER;
    private static final Collection<ClientListenerProtocolVersion> SUPPORTED_VERS;
    private ClientMessageParser parser;
    private ClientRequestHandler handler;
    private final ClientResourceRegistry resReg = new ClientResourceRegistry();
    private final int maxCursors;
    private ClientListenerProtocolVersion currentVer;
    private AtomicReference<AffinityTopologyVersion> lastAffinityTopologyVersion = new AtomicReference();
    private final AtomicLong curCnt = new AtomicLong();
    private final int maxActiveTxCnt;
    private final AtomicInteger txIdSeq = new AtomicInteger();
    private final Map<Integer, ClientTxContext> txs = new ConcurrentHashMap<Integer, ClientTxContext>();
    private final AtomicInteger txsCnt = new AtomicInteger();

    public ClientConnectionContext(GridKernalContext ctx, long connId, int maxCursors, ThinClientConfiguration thinCfg) {
        super(ctx, connId);
        this.maxCursors = maxCursors;
        this.maxActiveTxCnt = thinCfg.getMaxActiveTxPerConnection();
    }

    public ClientResourceRegistry resources() {
        return this.resReg;
    }

    @Override
    public boolean isVersionSupported(ClientListenerProtocolVersion ver) {
        return SUPPORTED_VERS.contains(ver);
    }

    @Override
    public ClientListenerProtocolVersion defaultVersion() {
        return DEFAULT_VER;
    }

    public ClientListenerProtocolVersion currentVersion() {
        return this.currentVer;
    }

    @Override
    public void initializeFromHandshake(ClientListenerProtocolVersion ver, BinaryReaderExImpl reader) throws IgniteCheckedException {
        String user = null;
        String pwd = null;
        if (ver.compareTo(VER_1_1_0) >= 0) {
            boolean hasMore;
            try {
                hasMore = reader.available() > 0;
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Handshake error: " + e.getMessage(), e);
            }
            if (hasMore) {
                user = reader.readString();
                pwd = reader.readString();
            }
        }
        AuthorizationContext authCtx = this.authenticate(user, pwd);
        this.currentVer = ver;
        this.handler = new ClientRequestHandler(this, authCtx, ver);
        this.parser = new ClientMessageParser(this, ver);
    }

    @Override
    public ClientListenerRequestHandler handler() {
        return this.handler;
    }

    @Override
    public ClientListenerMessageParser parser() {
        return this.parser;
    }

    @Override
    public void onDisconnected() {
        this.resReg.clean();
        this.cleanupTxs();
        super.onDisconnected();
    }

    public void incrementCursors() {
        long curCnt0 = this.curCnt.get();
        if (curCnt0 >= (long)this.maxCursors) {
            throw new IgniteClientException(1010, "Too many open cursors (either close other open cursors or increase the limit through ClientConnectorConfiguration.maxOpenCursorsPerConnection) [maximum=" + this.maxCursors + ", current=" + curCnt0 + ']');
        }
        this.curCnt.incrementAndGet();
    }

    public void decrementCursors() {
        this.curCnt.decrementAndGet();
    }

    public ClientAffinityTopologyVersion checkAffinityTopologyVersion() {
        AffinityTopologyVersion newVer;
        AffinityTopologyVersion oldVer;
        boolean success;
        boolean changed;
        do {
            oldVer = this.lastAffinityTopologyVersion.get();
            newVer = this.ctx.cache().context().exchange().readyAffinityVersion();
            boolean bl = changed = oldVer == null || oldVer.compareTo(newVer) < 0;
        } while (changed && !(success = this.lastAffinityTopologyVersion.compareAndSet(oldVer, newVer)));
        return new ClientAffinityTopologyVersion(newVer, changed);
    }

    public int nextTxId() {
        int txId = this.txIdSeq.incrementAndGet();
        return txId == 0 ? this.txIdSeq.incrementAndGet() : txId;
    }

    public ClientTxContext txContext(int txId) {
        return this.txs.get(txId);
    }

    public void addTxContext(ClientTxContext txCtx) {
        if (this.txsCnt.incrementAndGet() > this.maxActiveTxCnt) {
            this.txsCnt.decrementAndGet();
            throw new IgniteClientException(1020, "Active transactions per connection limit (" + this.maxActiveTxCnt + ") exceeded. To start a new transaction you need to wait for some of currently active transactions complete. To change the limit set up ThinClientConfiguration.MaxActiveTxPerConnection property.");
        }
        this.txs.put(txCtx.txId(), txCtx);
    }

    public void removeTxContext(int txId) {
        this.txs.remove(txId);
        this.txsCnt.decrementAndGet();
    }

    private void cleanupTxs() {
        for (ClientTxContext txCtx : this.txs.values()) {
            txCtx.close();
        }
        this.txs.clear();
    }

    static {
        DEFAULT_VER = VER_1_6_0 = ClientListenerProtocolVersion.create(1, 6, 0);
        SUPPORTED_VERS = Arrays.asList(VER_1_6_0, VER_1_5_0, VER_1_4_0, VER_1_3_0, VER_1_2_0, VER_1_1_0, VER_1_0_0);
    }
}

