/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterMetrics;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.mxbean.ClusterMetricsMXBean;

public class ClusterMetricsMXBeanImpl
implements ClusterMetricsMXBean {
    private final ClusterGroup cluster;
    private volatile ClusterMetrics clusterMetricsSnapshot;
    private volatile long clusterMetricsExpireTime;
    private final Object clusterMetricsMux = new Object();

    public ClusterMetricsMXBeanImpl(ClusterGroup cluster) {
        assert (cluster != null);
        this.cluster = cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterMetrics metrics() {
        if (this.clusterMetricsExpireTime < System.currentTimeMillis()) {
            Object object = this.clusterMetricsMux;
            synchronized (object) {
                if (this.clusterMetricsExpireTime < System.currentTimeMillis()) {
                    this.clusterMetricsSnapshot = this.cluster.metrics();
                    this.clusterMetricsExpireTime = System.currentTimeMillis() + this.cluster.ignite().configuration().getMetricsUpdateFrequency();
                }
            }
        }
        return this.clusterMetricsSnapshot;
    }

    @Override
    public int getTotalCpus() {
        return this.metrics().getTotalCpus();
    }

    @Override
    public float getAverageActiveJobs() {
        return this.metrics().getAverageActiveJobs();
    }

    @Override
    public float getAverageCancelledJobs() {
        return this.metrics().getAverageCancelledJobs();
    }

    @Override
    public double getAverageJobExecuteTime() {
        return this.metrics().getAverageJobExecuteTime();
    }

    @Override
    public double getAverageJobWaitTime() {
        return this.metrics().getAverageJobWaitTime();
    }

    @Override
    public float getAverageRejectedJobs() {
        return this.metrics().getAverageRejectedJobs();
    }

    @Override
    public float getAverageWaitingJobs() {
        return this.metrics().getAverageWaitingJobs();
    }

    @Override
    public float getBusyTimePercentage() {
        return this.metrics().getBusyTimePercentage() * 100.0f;
    }

    @Override
    public int getCurrentActiveJobs() {
        return this.metrics().getCurrentActiveJobs();
    }

    @Override
    public int getCurrentCancelledJobs() {
        return this.metrics().getCurrentCancelledJobs();
    }

    @Override
    public long getCurrentIdleTime() {
        return this.metrics().getCurrentIdleTime();
    }

    @Override
    public long getCurrentJobExecuteTime() {
        return this.metrics().getCurrentJobExecuteTime();
    }

    @Override
    public long getCurrentJobWaitTime() {
        return this.metrics().getCurrentJobWaitTime();
    }

    @Override
    public int getCurrentRejectedJobs() {
        return this.metrics().getCurrentRejectedJobs();
    }

    @Override
    public int getCurrentWaitingJobs() {
        return this.metrics().getCurrentWaitingJobs();
    }

    @Override
    public int getTotalExecutedTasks() {
        return this.metrics().getTotalExecutedTasks();
    }

    @Override
    public int getCurrentDaemonThreadCount() {
        return this.metrics().getCurrentDaemonThreadCount();
    }

    @Override
    public long getHeapMemoryCommitted() {
        return this.metrics().getHeapMemoryCommitted();
    }

    @Override
    public long getHeapMemoryInitialized() {
        return this.metrics().getHeapMemoryInitialized();
    }

    @Override
    public long getHeapMemoryMaximum() {
        return this.metrics().getHeapMemoryMaximum();
    }

    @Override
    public long getHeapMemoryTotal() {
        return this.metrics().getHeapMemoryTotal();
    }

    @Override
    public long getHeapMemoryUsed() {
        return this.metrics().getHeapMemoryUsed();
    }

    @Override
    public float getIdleTimePercentage() {
        return this.metrics().getIdleTimePercentage() * 100.0f;
    }

    @Override
    public long getLastUpdateTime() {
        return this.metrics().getLastUpdateTime();
    }

    @Override
    public int getMaximumActiveJobs() {
        return this.metrics().getMaximumActiveJobs();
    }

    @Override
    public int getMaximumCancelledJobs() {
        return this.metrics().getMaximumCancelledJobs();
    }

    @Override
    public long getMaximumJobExecuteTime() {
        return this.metrics().getMaximumJobExecuteTime();
    }

    @Override
    public long getMaximumJobWaitTime() {
        return this.metrics().getMaximumJobWaitTime();
    }

    @Override
    public int getMaximumRejectedJobs() {
        return this.metrics().getMaximumRejectedJobs();
    }

    @Override
    public int getMaximumWaitingJobs() {
        return this.metrics().getMaximumWaitingJobs();
    }

    @Override
    public long getNonHeapMemoryCommitted() {
        return this.metrics().getNonHeapMemoryCommitted();
    }

    @Override
    public long getNonHeapMemoryInitialized() {
        return this.metrics().getNonHeapMemoryInitialized();
    }

    @Override
    public long getNonHeapMemoryMaximum() {
        return this.metrics().getNonHeapMemoryMaximum();
    }

    @Override
    public long getNonHeapMemoryTotal() {
        return this.metrics().getNonHeapMemoryTotal();
    }

    @Override
    public long getNonHeapMemoryUsed() {
        return this.metrics().getNonHeapMemoryUsed();
    }

    @Override
    public int getMaximumThreadCount() {
        return this.metrics().getMaximumThreadCount();
    }

    @Override
    public long getStartTime() {
        return this.metrics().getStartTime();
    }

    @Override
    public long getNodeStartTime() {
        return this.metrics().getNodeStartTime();
    }

    @Override
    public double getCurrentCpuLoad() {
        return this.metrics().getCurrentCpuLoad() * 100.0;
    }

    @Override
    public double getAverageCpuLoad() {
        return this.metrics().getAverageCpuLoad() * 100.0;
    }

    @Override
    public double getCurrentGcCpuLoad() {
        return this.metrics().getCurrentGcCpuLoad() * 100.0;
    }

    @Override
    public int getCurrentThreadCount() {
        return this.metrics().getCurrentThreadCount();
    }

    @Override
    public long getTotalBusyTime() {
        return this.metrics().getTotalBusyTime();
    }

    @Override
    public int getTotalCancelledJobs() {
        return this.metrics().getTotalCancelledJobs();
    }

    @Override
    public int getTotalExecutedJobs() {
        return this.metrics().getTotalExecutedJobs();
    }

    @Override
    public long getTotalJobsExecutionTime() {
        return this.metrics().getTotalJobsExecutionTime();
    }

    @Override
    public long getTotalIdleTime() {
        return this.metrics().getTotalIdleTime();
    }

    @Override
    public int getTotalRejectedJobs() {
        return this.metrics().getTotalRejectedJobs();
    }

    @Override
    public long getTotalStartedThreadCount() {
        return this.metrics().getTotalStartedThreadCount();
    }

    @Override
    public long getUpTime() {
        return this.metrics().getUpTime();
    }

    @Override
    public long getLastDataVersion() {
        return this.metrics().getLastDataVersion();
    }

    @Override
    public int getSentMessagesCount() {
        return this.metrics().getSentMessagesCount();
    }

    @Override
    public long getSentBytesCount() {
        return this.metrics().getSentBytesCount();
    }

    @Override
    public int getReceivedMessagesCount() {
        return this.metrics().getReceivedMessagesCount();
    }

    @Override
    public long getReceivedBytesCount() {
        return this.metrics().getReceivedBytesCount();
    }

    @Override
    public int getOutboundMessagesQueueSize() {
        return this.metrics().getOutboundMessagesQueueSize();
    }

    @Override
    public int getTotalNodes() {
        return this.metrics().getTotalNodes();
    }

    @Override
    public long getCurrentPmeDuration() {
        return this.metrics().getCurrentPmeDuration();
    }

    @Override
    public int getTotalBaselineNodes() {
        Collection<BaselineNode> baselineNodes = this.cluster.ignite().cluster().currentBaselineTopology();
        return baselineNodes != null ? baselineNodes.size() : 0;
    }

    @Override
    public int getActiveBaselineNodes() {
        Collection<BaselineNode> baselineNodes = this.cluster.ignite().cluster().currentBaselineTopology();
        if (baselineNodes != null && !baselineNodes.isEmpty()) {
            HashSet<Object> bltIds = new HashSet<Object>(baselineNodes.size());
            for (BaselineNode baselineNode : baselineNodes) {
                bltIds.add(baselineNode.consistentId());
            }
            int count = 0;
            for (ClusterNode node : this.cluster.forServers().nodes()) {
                if (!bltIds.contains(node.consistentId())) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public int getTotalServerNodes() {
        return this.cluster.forServers().nodes().size();
    }

    @Override
    public int getTotalClientNodes() {
        return this.cluster.forClients().nodes().size();
    }

    @Override
    public long getTopologyVersion() {
        return this.cluster.ignite().cluster().topologyVersion();
    }

    @Override
    public Set<String> attributeNames() {
        TreeSet<String> attrs = new TreeSet<String>();
        for (ClusterNode node : this.cluster.nodes()) {
            attrs.addAll(node.attributes().keySet());
        }
        return attrs;
    }

    @Override
    public Set<String> attributeValues(String attrName) {
        TreeSet<String> values = new TreeSet<String>();
        for (ClusterNode node : this.cluster.nodes()) {
            Object val = node.attribute(attrName);
            if (val == null) continue;
            values.add(val.toString());
        }
        return values;
    }

    @Override
    public Set<UUID> nodeIdsForAttribute(String attrName, String attrVal, boolean includeSrvs, boolean includeClients) {
        TreeSet<UUID> nodes = new TreeSet<UUID>();
        for (ClusterNode node : this.nodesList(includeSrvs, includeClients)) {
            Object val = node.attribute(attrName);
            if (val == null || !val.toString().equals(attrVal)) continue;
            nodes.add(node.id());
        }
        return nodes;
    }

    private List<ClusterNode> nodesList(boolean srv, boolean client) {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
        if (srv) {
            nodes.addAll(this.cluster.forServers().nodes());
        }
        if (client) {
            nodes.addAll(this.cluster.forClients().nodes());
        }
        return nodes;
    }

    public String toString() {
        return S.toString(ClusterMetricsMXBeanImpl.class, this);
    }
}

