/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResultInfo;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcQueryExecuteMultipleStatementsResult
extends JdbcResult {
    private List<JdbcResultInfo> results;
    private List<List<Object>> items;
    private boolean last;

    JdbcQueryExecuteMultipleStatementsResult() {
        super((byte)13);
    }

    public JdbcQueryExecuteMultipleStatementsResult(List<JdbcResultInfo> results, List<List<Object>> items, boolean last) {
        super((byte)13);
        this.results = results;
        this.items = items;
        this.last = last;
    }

    public List<JdbcResultInfo> results() {
        return this.results;
    }

    public List<List<Object>> items() {
        return this.items;
    }

    public boolean isLast() {
        return this.last;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        if (this.results != null && !this.results.isEmpty()) {
            writer.writeInt(this.results.size());
            for (JdbcResultInfo r : this.results) {
                r.writeBinary(writer, ver);
            }
            if (this.results.get(0).isQuery()) {
                writer.writeBoolean(this.last);
                JdbcUtils.writeItems(writer, this.items);
            }
        } else {
            writer.writeInt(0);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        int cnt = reader.readInt();
        if (cnt == 0) {
            this.results = Collections.emptyList();
        } else {
            this.results = new ArrayList<JdbcResultInfo>(cnt);
            for (int i = 0; i < cnt; ++i) {
                JdbcResultInfo r = new JdbcResultInfo();
                r.readBinary(reader, ver);
                this.results.add(r);
            }
            if (this.results.get(0).isQuery()) {
                this.last = reader.readBoolean();
                this.items = JdbcUtils.readItems(reader);
            }
        }
    }

    public String toString() {
        return S.toString(JdbcQueryExecuteMultipleStatementsResult.class, this);
    }
}

