/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMeta;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;

class JdbcQueryCursor {
    private final long queryId;
    private int pageSize;
    private final long maxRows;
    private long fetched;
    private final QueryCursorImpl<List<Object>> cur;
    private final Iterator<List<Object>> iter;

    JdbcQueryCursor(long queryId, int pageSize, int maxRows, QueryCursorImpl<List<Object>> cur) {
        this.queryId = queryId;
        this.pageSize = pageSize;
        this.maxRows = maxRows;
        this.cur = cur;
        this.iter = cur.iterator();
    }

    List<List<Object>> fetchRows() {
        int fetchSize = this.maxRows > 0L ? (int)Math.min((long)this.pageSize, this.maxRows - this.fetched) : this.pageSize;
        ArrayList<List<Object>> items = new ArrayList<List<Object>>(fetchSize);
        for (int i = 0; i < fetchSize && this.iter.hasNext(); ++i) {
            items.add(this.iter.next());
            ++this.fetched;
        }
        return items;
    }

    List<JdbcColumnMeta> meta() {
        List<GridQueryFieldMetadata> meta = this.cur.fieldsMeta();
        ArrayList<JdbcColumnMeta> res = new ArrayList<JdbcColumnMeta>();
        if (meta != null) {
            for (GridQueryFieldMetadata info : meta) {
                assert (info instanceof GridQueryFieldMetadata);
                res.add(new JdbcColumnMeta(info));
            }
        }
        return res;
    }

    boolean hasNext() {
        return this.iter.hasNext() && (this.maxRows <= 0L || this.fetched < this.maxRows);
    }

    public long queryId() {
        return this.queryId;
    }

    public void close() {
        this.cur.close();
    }

    public void pageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isQuery() {
        return this.cur.isQuery();
    }
}

