/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class JdbcBatchExecuteRequest
extends JdbcRequest {
    private String schemaName;
    @GridToStringInclude(sensitive=true)
    private List<JdbcQuery> queries;
    private boolean autoCommit;
    private boolean lastStreamBatch;

    public JdbcBatchExecuteRequest() {
        super((byte)6);
    }

    protected JdbcBatchExecuteRequest(byte type) {
        super(type);
    }

    public JdbcBatchExecuteRequest(String schemaName, List<JdbcQuery> queries, boolean autoCommit, boolean lastStreamBatch) {
        super((byte)6);
        assert (lastStreamBatch || !F.isEmpty(queries));
        this.schemaName = schemaName;
        this.queries = queries;
        this.autoCommit = autoCommit;
        this.lastStreamBatch = lastStreamBatch;
    }

    protected JdbcBatchExecuteRequest(byte type, String schemaName, List<JdbcQuery> queries, boolean autoCommit, boolean lastStreamBatch) {
        super(type);
        assert (lastStreamBatch || !F.isEmpty(queries));
        this.schemaName = schemaName;
        this.queries = queries;
        this.autoCommit = autoCommit;
        this.lastStreamBatch = lastStreamBatch;
    }

    @Nullable
    public String schemaName() {
        return this.schemaName;
    }

    public List<JdbcQuery> queries() {
        return this.queries;
    }

    boolean autoCommit() {
        return this.autoCommit;
    }

    public boolean isLastStreamBatch() {
        return this.lastStreamBatch;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        writer.writeString(this.schemaName);
        if (!F.isEmpty(this.queries)) {
            writer.writeInt(this.queries.size());
            for (JdbcQuery q : this.queries) {
                q.writeBinary(writer, ver);
            }
        } else {
            writer.writeInt(0);
        }
        if (ver.compareTo(JdbcConnectionContext.VER_2_4_0) >= 0) {
            writer.writeBoolean(this.lastStreamBatch);
        }
        if (ver.compareTo(JdbcConnectionContext.VER_2_7_0) >= 0) {
            writer.writeBoolean(this.autoCommit);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        this.schemaName = reader.readString();
        int n = reader.readInt();
        this.queries = new ArrayList<JdbcQuery>(n);
        for (int i = 0; i < n; ++i) {
            JdbcQuery qry = new JdbcQuery();
            qry.readBinary(reader, ver);
            this.queries.add(qry);
        }
        if (ver.compareTo(JdbcConnectionContext.VER_2_4_0) >= 0) {
            this.lastStreamBatch = reader.readBoolean();
        }
        if (ver.compareTo(JdbcConnectionContext.VER_2_7_0) >= 0) {
            this.autoCommit = reader.readBoolean();
        }
    }

    public String toString() {
        return S.toString(JdbcBatchExecuteRequest.class, this);
    }
}

