/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearSingleGetRequest
extends GridCacheIdMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    private static final int READ_THROUGH_FLAG_MASK = 1;
    private static final int SKIP_VALS_FLAG_MASK = 2;
    private static final int ADD_READER_FLAG_MASK = 4;
    private static final int NEED_VER_FLAG_MASK = 8;
    private static final int NEED_ENTRY_INFO_FLAG_MASK = 16;
    public static final int RECOVERY_FLAG_MASK = 32;
    private long futId;
    private KeyCacheObject key;
    private byte flags;
    private AffinityTopologyVersion topVer;
    private UUID subjId;
    private int taskNameHash;
    private long createTtl;
    private long accessTtl;
    private MvccSnapshot mvccSnapshot;

    public GridNearSingleGetRequest() {
    }

    public GridNearSingleGetRequest(int cacheId, long futId, KeyCacheObject key, boolean readThrough, @NotNull AffinityTopologyVersion topVer, UUID subjId, int taskNameHash, long createTtl, long accessTtl, boolean skipVals, boolean addReader, boolean needVer, boolean addDepInfo, boolean recovery, MvccSnapshot mvccSnapshot) {
        assert (key != null);
        this.cacheId = cacheId;
        this.futId = futId;
        this.key = key;
        this.topVer = topVer;
        this.subjId = subjId;
        this.taskNameHash = taskNameHash;
        this.createTtl = createTtl;
        this.accessTtl = accessTtl;
        this.addDepInfo = addDepInfo;
        this.mvccSnapshot = mvccSnapshot;
        if (readThrough) {
            this.flags = (byte)(this.flags | 1);
        }
        if (skipVals) {
            this.flags = (byte)(this.flags | 2);
        }
        if (addReader) {
            this.flags = (byte)(this.flags | 4);
        }
        if (needVer) {
            this.flags = (byte)(this.flags | 8);
        }
        if (recovery) {
            this.flags = (byte)(this.flags | 0x20);
        }
    }

    @Nullable
    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public KeyCacheObject key() {
        return this.key;
    }

    public long futureId() {
        return this.futId;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public long createTtl() {
        return this.createTtl;
    }

    public long accessTtl() {
        return this.accessTtl;
    }

    @Override
    public int partition() {
        assert (this.key != null);
        return this.key.partition();
    }

    public boolean readThrough() {
        return (this.flags & 1) != 0;
    }

    public boolean skipValues() {
        return (this.flags & 2) != 0;
    }

    public boolean addReader() {
        return (this.flags & 4) != 0;
    }

    public boolean needVersion() {
        return (this.flags & 8) != 0;
    }

    public boolean needEntryInfo() {
        return (this.flags & 0x10) != 0;
    }

    public boolean recovery() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        assert (this.key != null);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.prepareMarshalCacheObject(this.key, cctx);
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        assert (this.key != null);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        this.key.finishUnmarshal(cctx.cacheObjectContext(), ldr);
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.accessTtl = reader.readLong("accessTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.createTtl = reader.readLong("createTtl");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.topVer = (AffinityTopologyVersion)reader.readMessage("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.mvccSnapshot = (MvccSnapshot)reader.readMessage("mvccSnapshot");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearSingleGetRequest.class);
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeLong("accessTtl", this.accessTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeLong("createTtl", this.createTtl)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeMessage("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeMessage("mvccSnapshot", this.mvccSnapshot)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public short directType() {
        return 116;
    }

    @Override
    public byte fieldsCount() {
        return 12;
    }

    @Override
    public String toString() {
        return S.toString(GridNearSingleGetRequest.class, this);
    }
}

