/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CachePartitionFullCountersMap
implements Serializable {
    private static final long serialVersionUID = 0L;
    private long[] initialUpdCntrs;
    private long[] updCntrs;

    public CachePartitionFullCountersMap(CachePartitionFullCountersMap other) {
        this.initialUpdCntrs = Arrays.copyOf(other.initialUpdCntrs, other.initialUpdCntrs.length);
        this.updCntrs = Arrays.copyOf(other.updCntrs, other.updCntrs.length);
    }

    public CachePartitionFullCountersMap(int partsCnt) {
        this.initialUpdCntrs = new long[partsCnt];
        this.updCntrs = new long[partsCnt];
    }

    public long initialUpdateCounter(int p) {
        return this.initialUpdCntrs[p];
    }

    public long updateCounter(int p) {
        return this.updCntrs[p];
    }

    public void initialUpdateCounter(int p, long initialUpdCntr) {
        this.initialUpdCntrs[p] = initialUpdCntr;
    }

    public void updateCounter(int p, long updCntr) {
        this.updCntrs[p] = updCntr;
    }

    public CachePartitionPartialCountersMap subMap(Set<Integer> parts) {
        CachePartitionPartialCountersMap res = new CachePartitionPartialCountersMap(parts.size());
        for (int p = 0; p < this.updCntrs.length; ++p) {
            if (!parts.contains(p)) continue;
            res.add(p, this.initialUpdCntrs[p], this.updCntrs[p]);
        }
        assert (res.size() == parts.size());
        return res;
    }

    public void clear() {
        Arrays.fill(this.initialUpdCntrs, 0L);
        Arrays.fill(this.updCntrs, 0L);
    }

    public static Map<Integer, T2<Long, Long>> toCountersMap(CachePartitionFullCountersMap map) {
        int partsCnt = map.updCntrs.length;
        HashMap<Integer, T2<Long, Long>> map0 = U.newHashMap(partsCnt);
        for (int p = 0; p < partsCnt; ++p) {
            map0.put(p, new T2<Long, Long>(map.initialUpdCntrs[p], map.updCntrs[p]));
        }
        return map0;
    }

    static CachePartitionFullCountersMap fromCountersMap(Map<Integer, T2<Long, Long>> map, int partsCnt) {
        CachePartitionFullCountersMap map0 = new CachePartitionFullCountersMap(partsCnt);
        for (Map.Entry<Integer, T2<Long, Long>> e : map.entrySet()) {
            T2<Long, Long> cntrs = e.getValue();
            map0.initialUpdCntrs[e.getKey().intValue()] = (Long)cntrs.get1();
            map0.updCntrs[e.getKey().intValue()] = (Long)cntrs.get2();
        }
        return map0;
    }
}

