/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.cluster.ClusterTopologyException;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeJobResultPolicy;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.cluster.ClusterGroupEmptyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheOperationContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheConcurrentMap;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerCacheUpdaters;
import org.apache.ignite.internal.processors.datastreamer.DataStreamerImpl;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.GridTaskThreadContextKey;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridDistributedCacheAdapter<K, V>
extends GridCacheAdapter<K, V> {
    private static final long serialVersionUID = 0L;

    protected GridDistributedCacheAdapter() {
    }

    protected GridDistributedCacheAdapter(GridCacheContext<K, V> ctx) {
        super(ctx);
    }

    protected GridDistributedCacheAdapter(GridCacheContext<K, V> ctx, GridCacheConcurrentMap map) {
        super(ctx, map);
    }

    @Override
    public IgniteInternalFuture<Boolean> txLockAsync(Collection<KeyCacheObject> keys, long timeout, IgniteTxLocalEx tx, boolean isRead, boolean retval, TransactionIsolation isolation, boolean isInvalidate, long createTtl, long accessTtl) {
        assert (tx != null);
        return this.lockAllAsync(keys, timeout, tx, isInvalidate, isRead, retval, isolation, createTtl, accessTtl);
    }

    @Override
    public IgniteInternalFuture<Boolean> lockAllAsync(Collection<? extends K> keys, long timeout) {
        GridNearTxLocal tx = this.ctx.tm().userTx();
        return this.lockAllAsync(this.ctx.cacheKeysView(keys), timeout, tx, false, false, true, null, -1L, -1L);
    }

    protected abstract IgniteInternalFuture<Boolean> lockAllAsync(Collection<KeyCacheObject> var1, long var2, @Nullable IgniteTxLocalEx var4, boolean var5, boolean var6, boolean var7, @Nullable TransactionIsolation var8, long var9, long var11);

    public void removeVersionedEntry(KeyCacheObject key, GridCacheVersion ver) {
        GridCacheEntryEx entry = this.peekEx(key);
        if (entry == null) {
            return;
        }
        if (entry.markObsoleteVersion(ver)) {
            this.removeEntry(entry);
        }
    }

    @Override
    public void removeAll() throws IgniteCheckedException {
        block3: {
            try {
                boolean retry;
                AffinityTopologyVersion topVer;
                CacheOperationContext opCtx = this.ctx.operationContextPerCall();
                boolean skipStore = opCtx != null && opCtx.skipStore();
                boolean keepBinary = opCtx != null && opCtx.isKeepBinary();
                do {
                    retry = false;
                    topVer = this.ctx.affinity().affinityTopologyVersion();
                    Collection<ClusterNode> nodes = this.ctx.grid().cluster().forDataNodes(this.name()).nodes();
                    if (nodes.isEmpty()) continue;
                    this.ctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
                    boolean bl = retry = (Boolean)this.ctx.kernalContext().task().execute(new RemoveAllTask(this.ctx.name(), topVer, skipStore, keepBinary), null).get() == false;
                } while (this.ctx.affinity().affinityTopologyVersion().compareTo(topVer) != 0 || retry);
            }
            catch (ClusterGroupEmptyCheckedException ignore) {
                if (!this.log.isDebugEnabled()) break block3;
                this.log.debug("All remote nodes left while cache remove [cacheName=" + this.name() + "]");
            }
        }
    }

    @Override
    public IgniteInternalFuture<?> removeAllAsync() {
        GridFutureAdapter<Void> opFut = new GridFutureAdapter<Void>();
        AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
        CacheOperationContext opCtx = this.ctx.operationContextPerCall();
        this.removeAllAsync(opFut, topVer, opCtx != null && opCtx.skipStore(), opCtx != null && opCtx.isKeepBinary());
        return opFut;
    }

    private void removeAllAsync(final GridFutureAdapter<Void> opFut, final AffinityTopologyVersion topVer, final boolean skipStore, final boolean keepBinary) {
        Collection<ClusterNode> nodes = this.ctx.grid().cluster().forDataNodes(this.name()).nodes();
        if (!nodes.isEmpty()) {
            this.ctx.kernalContext().task().setThreadContext(GridTaskThreadContextKey.TC_SUBGRID, nodes);
            ComputeTaskInternalFuture<Boolean> rmvAll = this.ctx.kernalContext().task().execute(new RemoveAllTask(this.ctx.name(), topVer, skipStore, keepBinary), null);
            rmvAll.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                @Override
                public void apply(IgniteInternalFuture<Boolean> fut) {
                    try {
                        boolean retry = fut.get() == false;
                        AffinityTopologyVersion topVer0 = GridDistributedCacheAdapter.this.ctx.affinity().affinityTopologyVersion();
                        if (topVer0.equals(topVer) && !retry) {
                            opFut.onDone();
                        } else {
                            GridDistributedCacheAdapter.this.removeAllAsync(opFut, topVer0, skipStore, keepBinary);
                        }
                    }
                    catch (ClusterGroupEmptyCheckedException ignore) {
                        if (GridDistributedCacheAdapter.this.log.isDebugEnabled()) {
                            GridDistributedCacheAdapter.this.log.debug("All remote nodes left while cache remove [cacheName=" + GridDistributedCacheAdapter.this.name() + "]");
                        }
                        opFut.onDone();
                    }
                    catch (IgniteCheckedException e) {
                        opFut.onDone(e);
                    }
                    catch (Error e) {
                        opFut.onDone(e);
                        throw e;
                    }
                }
            });
        } else {
            opFut.onDone();
        }
    }

    @Override
    public long localSizeLong(CachePeekMode[] peekModes) throws IgniteCheckedException {
        GridCacheAdapter.PeekModes modes = GridDistributedCacheAdapter.parsePeekModes(peekModes, true);
        long size = 0L;
        if (modes.near) {
            size += (long)this.nearSize();
        }
        if (modes.primary || modes.backup) {
            AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
            IgniteCacheOffheapManager offheap = this.ctx.offheap();
            if (modes.offheap) {
                size += offheap.cacheEntriesCount(this.ctx.cacheId(), modes.primary, modes.backup, topVer);
            } else if (modes.heap) {
                for (GridDhtLocalPartition locPart : this.ctx.topology().currentLocalPartitions()) {
                    if ((!modes.primary || !locPart.primary(topVer)) && (!modes.backup || !locPart.backup(topVer))) continue;
                    size += (long)locPart.publicSize(this.ctx.cacheId());
                }
            }
        }
        return size;
    }

    @Override
    public long localSizeLong(int part, CachePeekMode[] peekModes) throws IgniteCheckedException {
        GridCacheAdapter.PeekModes modes = GridDistributedCacheAdapter.parsePeekModes(peekModes, true);
        long size = 0L;
        if (modes.near) {
            size += (long)this.nearSize();
        }
        if (modes.offheap) {
            AffinityTopologyVersion topVer = this.ctx.affinity().affinityTopologyVersion();
            IgniteCacheOffheapManager offheap = this.ctx.offheap();
            if (this.ctx.affinity().primaryByPartition(this.ctx.localNode(), part, topVer) && modes.primary || this.ctx.affinity().backupByPartition(this.ctx.localNode(), part, topVer) && modes.backup) {
                size += offheap.cacheEntriesCount(this.ctx.cacheId(), part);
            }
        }
        return size;
    }

    @Override
    public String toString() {
        return S.toString(GridDistributedCacheAdapter.class, this, "super", super.toString());
    }

    @GridInternal
    private static class GlobalRemoveAllJob<K, V>
    extends GridCacheAdapter.TopologyVersionAwareJob {
        private static final long serialVersionUID = 0L;
        private final boolean skipStore;
        private final boolean keepBinary;

        private GlobalRemoveAllJob(String cacheName, @NotNull AffinityTopologyVersion topVer, boolean skipStore, boolean keepBinary) {
            super(cacheName, topVer);
            this.skipStore = skipStore;
            this.keepBinary = keepBinary;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @Nullable
        public Object localExecute(@Nullable IgniteInternalCache cache0) {
            GridCacheAdapter cache = ((IgniteKernal)this.ignite).context().cache().internalCache(this.cacheName);
            if (cache == null) {
                return true;
            }
            GridCacheContext ctx = cache.context();
            ctx.gate().enter();
            try {
                GridDhtCacheAdapter dht;
                if (!ctx.affinity().affinityTopologyVersion().equals(this.topVer)) {
                    Boolean bl = false;
                    return bl;
                }
                GridNearCacheAdapter near = null;
                if (cache instanceof GridNearCacheAdapter) {
                    near = (GridNearCacheAdapter)cache;
                    dht = near.dht();
                } else {
                    dht = (GridDhtCacheAdapter)cache;
                }
                DataStreamerImpl dataLdr = (DataStreamerImpl)this.ignite.dataStreamer(this.cacheName);
                Object object = null;
                try {
                    dataLdr.maxRemapCount(0);
                    dataLdr.skipStore(this.skipStore);
                    dataLdr.keepBinary(this.keepBinary);
                    dataLdr.receiver(DataStreamerCacheUpdaters.batched());
                    for (int part : ctx.affinity().primaryPartitions(ctx.localNodeId(), this.topVer)) {
                        GridDhtLocalPartition locPart = dht.topology().localPartition(part, this.topVer, false);
                        if (locPart == null || ctx.rebalanceEnabled() && locPart.state() != GridDhtPartitionState.OWNING || !locPart.reserve()) {
                            Boolean bl = false;
                            return bl;
                        }
                        try {
                            GridCloseableIterator<KeyCacheObject> iter = dht.context().offheap().cacheKeysIterator(ctx.cacheId(), part);
                            if (iter == null) continue;
                            try {
                                while (iter.hasNext()) {
                                    dataLdr.removeDataInternal((KeyCacheObject)iter.next());
                                }
                            }
                            finally {
                                iter.close();
                            }
                        }
                        finally {
                            locPart.release();
                        }
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dataLdr != null) {
                        if (object != null) {
                            try {
                                dataLdr.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dataLdr.close();
                        }
                    }
                }
                if (near == null) return true;
                GridCacheVersion obsoleteVer = ctx.versions().next();
                object = near.allEntries().iterator();
                while (object.hasNext()) {
                    GridCacheEntryEx e = (GridCacheEntryEx)object.next();
                    if (e.valid(this.topVer) || !e.markObsolete(obsoleteVer)) continue;
                    near.removeEntry(e);
                }
                return true;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
            finally {
                ctx.gate().leave();
            }
        }
    }

    @GridInternal
    private static class RemoveAllTask
    extends ComputeTaskAdapter<Object, Boolean> {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        private final AffinityTopologyVersion topVer;
        private final boolean skipStore;
        private final boolean keepBinary;

        public RemoveAllTask(String cacheName, AffinityTopologyVersion topVer, boolean skipStore, boolean keepBinary) {
            this.cacheName = cacheName;
            this.topVer = topVer;
            this.skipStore = skipStore;
            this.keepBinary = keepBinary;
        }

        @Override
        @Nullable
        public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Object arg) throws IgniteException {
            HashMap jobs = new HashMap();
            for (ClusterNode node : subgrid) {
                jobs.put(new GlobalRemoveAllJob(this.cacheName, this.topVer, this.skipStore, this.keepBinary), node);
            }
            return jobs;
        }

        @Override
        public ComputeJobResultPolicy result(ComputeJobResult res, List<ComputeJobResult> rcvd) {
            IgniteException e = res.getException();
            if (e != null) {
                if (e instanceof ClusterTopologyException) {
                    return ComputeJobResultPolicy.WAIT;
                }
                throw new IgniteException("Remote job threw exception.", e);
            }
            return ComputeJobResultPolicy.WAIT;
        }

        @Override
        @Nullable
        public Boolean reduce(List<ComputeJobResult> results) throws IgniteException {
            for (ComputeJobResult locRes : results) {
                if (locRes == null || locRes.getException() == null && ((Boolean)locRes.getData()).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }
}

