/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.streams;

import java.util.Arrays;
import org.apache.ignite.internal.binary.streams.BinaryAbstractInputStream;
import org.apache.ignite.internal.util.GridUnsafe;

public final class BinaryHeapInputStream
extends BinaryAbstractInputStream {
    private byte[] data;

    public static BinaryHeapInputStream create(byte[] data, int pos) {
        assert (pos < data.length);
        BinaryHeapInputStream stream = new BinaryHeapInputStream(data);
        stream.pos = pos;
        return stream;
    }

    public BinaryHeapInputStream(byte[] data) {
        this.data = data;
        this.len = data.length;
    }

    public BinaryHeapInputStream copy() {
        BinaryHeapInputStream in = new BinaryHeapInputStream(Arrays.copyOf(this.data, this.data.length));
        in.position(this.pos);
        return in;
    }

    public byte[] resize(int len) {
        if (this.data.length < len) {
            byte[] data0 = new byte[len];
            System.arraycopy(this.data, 0, data0, 0, this.data.length);
            this.data = data0;
        }
        return this.data;
    }

    @Override
    public int remaining() {
        return this.data.length - this.pos;
    }

    @Override
    public int capacity() {
        return this.data.length;
    }

    @Override
    public byte[] array() {
        return this.data;
    }

    @Override
    public byte[] arrayCopy() {
        byte[] res = new byte[this.len];
        System.arraycopy(this.data, 0, res, 0, this.len);
        return res;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    protected byte readByteAndShift() {
        return this.data[this.pos++];
    }

    @Override
    protected void copyAndShift(Object target, long off, int len) {
        GridUnsafe.copyMemory(this.data, GridUnsafe.BYTE_ARR_OFF + (long)this.pos, target, off, len);
        this.shift(len);
    }

    @Override
    protected short readShortFast() {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getShortLE(this.data, off) : GridUnsafe.getShort(this.data, off);
    }

    @Override
    protected char readCharFast() {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getCharLE(this.data, off) : GridUnsafe.getChar(this.data, off);
    }

    @Override
    protected int readIntFast() {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getIntLE(this.data, off) : GridUnsafe.getInt(this.data, off);
    }

    @Override
    protected long readLongFast() {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getLongLE(this.data, off) : GridUnsafe.getLong(this.data, off);
    }

    @Override
    protected byte readBytePositioned0(int pos) {
        return GridUnsafe.getByte(this.data, GridUnsafe.BYTE_ARR_OFF + (long)pos);
    }

    @Override
    protected short readShortPositioned0(int pos) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getShortLE(this.data, off) : GridUnsafe.getShort(this.data, off);
    }

    @Override
    protected int readIntPositioned0(int pos) {
        long off = GridUnsafe.BYTE_ARR_OFF + (long)pos;
        return GridUnsafe.BIG_ENDIAN ? GridUnsafe.getIntLE(this.data, off) : GridUnsafe.getInt(this.data, off);
    }
}

