/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteDeploymentCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfo;
import org.apache.ignite.internal.managers.deployment.GridDeploymentInfoBean;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheDeploymentManager;
import org.apache.ignite.internal.processors.continuous.GridContinuousBatch;
import org.apache.ignite.internal.processors.continuous.GridContinuousBatchAdapter;
import org.apache.ignite.internal.processors.continuous.GridContinuousHandler;
import org.apache.ignite.internal.processors.platform.PlatformEventFilterListener;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P2;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.T3;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.Marshaller;
import org.jetbrains.annotations.Nullable;

class GridEventConsumeHandler
implements GridContinuousHandler {
    private static final long serialVersionUID = 0L;
    private static final IgniteBiPredicate<UUID, Event> DFLT_CALLBACK = new P2<UUID, Event>(){

        @Override
        public boolean apply(UUID uuid, Event e) {
            return true;
        }
    };
    private IgniteBiPredicate<UUID, Event> cb;
    private IgnitePredicate<Event> filter;
    private byte[] filterBytes;
    private String clsName;
    private GridDeploymentInfo depInfo;
    private int[] types;
    private GridLocalEventListener lsnr;

    public GridEventConsumeHandler() {
    }

    GridEventConsumeHandler(@Nullable IgniteBiPredicate<UUID, Event> cb, @Nullable IgnitePredicate<Event> filter, @Nullable int[] types) {
        this.cb = cb == null ? DFLT_CALLBACK : cb;
        this.filter = filter;
        this.types = types;
    }

    @Override
    public boolean isEvents() {
        return true;
    }

    @Override
    public boolean isMessaging() {
        return false;
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    @Override
    public boolean keepBinary() {
        return false;
    }

    @Override
    public String cacheName() {
        throw new IllegalStateException();
    }

    @Override
    public void updateCounters(AffinityTopologyVersion topVer, Map<UUID, Map<Integer, T2<Long, Long>>> cntrsPerNode, Map<Integer, T2<Long, Long>> cntrs) {
    }

    @Override
    public GridContinuousHandler.RegisterStatus register(final UUID nodeId, final UUID routineId, final GridKernalContext ctx) throws IgniteCheckedException {
        assert (nodeId != null);
        assert (routineId != null);
        assert (ctx != null);
        if (this.cb != null) {
            ctx.resource().injectGeneric(this.cb);
        }
        if (this.filter != null) {
            ctx.resource().injectGeneric(this.filter);
        }
        if (this.filter instanceof PlatformEventFilterListener) {
            ((PlatformEventFilterListener)this.filter).initialize(ctx);
        }
        final boolean loc = nodeId.equals(ctx.localNodeId());
        this.lsnr = new GridLocalEventListener(){
            private final Queue<T3<UUID, UUID, Event>> notificationQueue = new LinkedList<T3<UUID, UUID, Event>>();
            private boolean notificationInProgress;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEvent(Event evt) {
                if (GridEventConsumeHandler.this.filter != null && !GridEventConsumeHandler.this.filter.apply(evt)) {
                    return;
                }
                if (loc) {
                    if (!GridEventConsumeHandler.this.cb.apply(nodeId, evt)) {
                        ctx.continuous().stopRoutine(routineId);
                    }
                } else {
                    if (ctx.discovery().node(nodeId) == null) {
                        return;
                    }
                    Queue<T3<UUID, UUID, Event>> queue = this.notificationQueue;
                    synchronized (queue) {
                        this.notificationQueue.add(new T3<UUID, UUID, Event>(nodeId, routineId, evt));
                        if (!this.notificationInProgress) {
                            ctx.getSystemExecutorService().execute(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                @Override
                                public void run() {
                                    if (!ctx.continuous().lockStopping()) {
                                        return;
                                    }
                                    try {
                                        while (true) {
                                            T3 t3;
                                            Queue queue = notificationQueue;
                                            synchronized (queue) {
                                                t3 = (T3)notificationQueue.poll();
                                                if (t3 == null) {
                                                    notificationInProgress = false;
                                                    return;
                                                }
                                            }
                                            try {
                                                Event evt = (Event)t3.get3();
                                                EventWrapper wrapper = new EventWrapper(evt);
                                                if (evt instanceof CacheEvent) {
                                                    GridCacheContext cctx;
                                                    String cacheName = ((CacheEvent)evt).cacheName();
                                                    ClusterNode node = ctx.discovery().node((UUID)t3.get1());
                                                    if (node == null) continue;
                                                    if (ctx.config().isPeerClassLoadingEnabled() && (cctx = ctx.cache().internalCache(cacheName).context()).deploymentEnabled() && ctx.discovery().cacheNode(node, cacheName)) {
                                                        wrapper.p2pMarshal(ctx.config().getMarshaller());
                                                        wrapper.cacheName = cacheName;
                                                        cctx.deploy().prepare(wrapper);
                                                    }
                                                }
                                                ctx.continuous().addNotification((UUID)t3.get1(), (UUID)t3.get2(), wrapper, null, false, false);
                                            }
                                            catch (ClusterTopologyCheckedException evt) {
                                            }
                                            catch (Throwable e) {
                                                U.error(ctx.log(GridEventConsumeHandler.class), "Failed to send event notification to node: " + nodeId, e);
                                            }
                                        }
                                    }
                                    finally {
                                        ctx.continuous().unlockStopping();
                                    }
                                }
                            });
                            this.notificationInProgress = true;
                        }
                    }
                }
            }
        };
        if (F.isEmpty(this.types)) {
            this.types = EventType.EVTS_ALL;
        }
        ctx.event().addLocalEventListener(this.lsnr, this.types);
        return GridContinuousHandler.RegisterStatus.REGISTERED;
    }

    @Override
    public void unregister(UUID routineId, GridKernalContext ctx) {
        RuntimeException err;
        block10: {
            assert (routineId != null);
            assert (ctx != null);
            if (this.lsnr != null) {
                ctx.event().removeLocalEventListener(this.lsnr, this.types);
            }
            err = null;
            try {
                if (this.filter instanceof PlatformEventFilterListener) {
                    ((PlatformEventFilterListener)this.filter).onClose();
                }
            }
            catch (RuntimeException ex) {
                err = ex;
            }
            try {
                if (this.cb instanceof PlatformEventFilterListener) {
                    ((PlatformEventFilterListener)this.cb).onClose();
                }
            }
            catch (RuntimeException ex) {
                if (err != null) break block10;
                err = ex;
            }
        }
        if (err != null) {
            throw err;
        }
    }

    @Override
    public void notifyCallback(UUID nodeId, UUID routineId, Collection<?> objs, GridKernalContext ctx) {
        assert (nodeId != null);
        assert (routineId != null);
        assert (objs != null);
        assert (ctx != null);
        for (Object obj : objs) {
            assert (obj instanceof EventWrapper);
            EventWrapper wrapper = (EventWrapper)obj;
            if (wrapper.bytes != null) {
                assert (ctx.config().isPeerClassLoadingEnabled());
                GridCacheAdapter cache = ctx.cache().internalCache(wrapper.cacheName);
                ClassLoader ldr = null;
                if (cache != null) {
                    GridCacheDeploymentManager depMgr = cache.context().deploy();
                    GridDeploymentInfo depInfo = wrapper.depInfo;
                    if (depInfo != null) {
                        depMgr.p2pContext(nodeId, depInfo.classLoaderId(), depInfo.userVersion(), depInfo.deployMode(), depInfo.participants());
                    }
                    ldr = depMgr.globalLoader();
                } else {
                    U.warn(ctx.log(this.getClass()), "Received cache event for cache that is not configured locally when peer class loading is enabled: " + wrapper.cacheName + ". Will try to unmarshal with default class loader.");
                }
                try {
                    wrapper.p2pUnmarshal(ctx.config().getMarshaller(), U.resolveClassLoader(ldr, ctx.config()));
                }
                catch (IgniteCheckedException e) {
                    U.error(ctx.log(this.getClass()), "Failed to unmarshal event.", e);
                }
            }
            if (this.cb.apply(nodeId, wrapper.evt)) continue;
            ctx.continuous().stopRoutine(routineId);
            break;
        }
    }

    @Override
    public void p2pMarshal(GridKernalContext ctx) throws IgniteCheckedException {
        assert (ctx != null);
        assert (ctx.config().isPeerClassLoadingEnabled());
        if (this.filter != null) {
            Class<?> cls = U.detectClass(this.filter);
            this.clsName = cls.getName();
            GridDeployment dep = ctx.deploy().deploy(cls, U.detectClassLoader(cls));
            if (dep == null) {
                throw new IgniteDeploymentCheckedException("Failed to deploy event filter: " + this.filter);
            }
            this.depInfo = new GridDeploymentInfoBean(dep);
            this.filterBytes = U.marshal(ctx.config().getMarshaller(), this.filter);
        }
    }

    @Override
    public void p2pUnmarshal(UUID nodeId, GridKernalContext ctx) throws IgniteCheckedException {
        assert (nodeId != null);
        assert (ctx != null);
        assert (ctx.config().isPeerClassLoadingEnabled());
        if (this.filterBytes != null) {
            GridDeployment dep = ctx.deploy().getGlobalDeployment(this.depInfo.deployMode(), this.clsName, this.clsName, this.depInfo.userVersion(), nodeId, this.depInfo.classLoaderId(), this.depInfo.participants(), null);
            if (dep == null) {
                throw new IgniteDeploymentCheckedException("Failed to obtain deployment for class: " + this.clsName);
            }
            this.filter = (IgnitePredicate)U.unmarshal(ctx, this.filterBytes, U.resolveClassLoader(dep.classLoader(), ctx.config()));
        }
    }

    @Override
    public GridContinuousBatch createBatch() {
        return new GridContinuousBatchAdapter();
    }

    @Override
    public void onClientDisconnected() {
    }

    @Override
    public void onBatchAcknowledged(UUID routineId, GridContinuousBatch batch, GridKernalContext ctx) {
    }

    @Override
    public void onNodeLeft() {
    }

    @Override
    @Nullable
    public Object orderedTopic() {
        return null;
    }

    @Override
    public GridContinuousHandler clone() {
        try {
            return (GridContinuousHandler)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean b = this.filterBytes != null;
        out.writeBoolean(b);
        if (b) {
            U.writeByteArray(out, this.filterBytes);
            U.writeString(out, this.clsName);
            out.writeObject(this.depInfo);
        } else {
            out.writeObject(this.filter);
        }
        out.writeObject(this.types);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean b = in.readBoolean();
        if (b) {
            this.filterBytes = U.readByteArray(in);
            this.clsName = U.readString(in);
            this.depInfo = (GridDeploymentInfo)in.readObject();
        } else {
            this.filter = (IgnitePredicate)in.readObject();
        }
        this.types = (int[])in.readObject();
    }

    private static class EventWrapper
    implements GridCacheDeployable,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private Event evt;
        private byte[] bytes;
        private String cacheName;
        private GridDeploymentInfo depInfo;

        public EventWrapper() {
        }

        EventWrapper(Event evt) {
            assert (evt != null);
            this.evt = evt;
        }

        void p2pMarshal(Marshaller marsh) throws IgniteCheckedException {
            assert (marsh != null);
            this.bytes = U.marshal(marsh, (Object)this.evt);
        }

        void p2pUnmarshal(Marshaller marsh, @Nullable ClassLoader ldr) throws IgniteCheckedException {
            assert (marsh != null);
            assert (this.evt == null);
            assert (this.bytes != null);
            this.evt = (Event)U.unmarshal(marsh, this.bytes, ldr);
        }

        @Override
        public void prepare(GridDeploymentInfo depInfo) {
            assert (this.evt instanceof CacheEvent);
            this.depInfo = depInfo;
        }

        @Override
        public GridDeploymentInfo deployInfo() {
            return this.depInfo;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            boolean b = this.bytes != null;
            out.writeBoolean(b);
            if (b) {
                U.writeByteArray(out, this.bytes);
                U.writeString(out, this.cacheName);
                out.writeObject(this.depInfo);
            } else {
                out.writeObject(this.evt);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            boolean b = in.readBoolean();
            if (b) {
                this.bytes = U.readByteArray(in);
                this.cacheName = U.readString(in);
                this.depInfo = (GridDeploymentInfo)in.readObject();
            } else {
                this.evt = (Event)in.readObject();
            }
        }
    }
}

