/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.tx;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.tx.TxVerboseId;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class FetchNearXidVersionTask
extends VisorMultiNodeTask<TxVerboseId, GridCacheVersion, GridCacheVersion> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<TxVerboseId, GridCacheVersion> job(TxVerboseId arg) {
        return new FetchNearXidVersionJob(arg, this.debug);
    }

    @Override
    protected GridCacheVersion reduce0(List<ComputeJobResult> results) throws IgniteException {
        for (ComputeJobResult res : results) {
            if (res.getData() == null) continue;
            return (GridCacheVersion)res.getData();
        }
        return null;
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<TxVerboseId> arg) {
        return this.ignite.cluster().nodes().stream().map(ClusterNode::id).collect(Collectors.toList());
    }

    private static class FetchNearXidVersionJob
    extends VisorJob<TxVerboseId, GridCacheVersion> {
        private static final long serialVersionUID = 0L;

        public FetchNearXidVersionJob(TxVerboseId arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected GridCacheVersion run(@Nullable TxVerboseId arg) throws IgniteException {
            IgniteTxManager tm = this.ignite.context().cache().context().tm();
            Collection<IgniteInternalTx> transactions = tm.activeTransactions();
            for (IgniteInternalTx tx : transactions) {
                if (!tx.xid().equals(arg.uuid()) && !tx.nearXidVersion().asIgniteUuid().equals(arg.uuid()) && !tx.xidVersion().equals(arg.gridCacheVersion()) && !tx.nearXidVersion().equals(arg.gridCacheVersion())) continue;
                return tx.nearXidVersion();
            }
            return null;
        }
    }
}

