/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.types;

import io.netty.buffer.ByteBuf;
import java.util.GregorianCalendar;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.DoublePoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.QualityInformation;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;

public class TypeHelper {
    static void encodeTimestamp(ProtocolOptions options, ByteBuf out, long timestamp) {
        GregorianCalendar c = new GregorianCalendar(options.getTimeZone());
        c.setTimeInMillis(timestamp);
        int ms = c.get(13) * 1000 + c.get(14);
        int minutes = c.get(12);
        int hours = c.get(11);
        int dayOfMonth = c.get(5);
        int month = c.get(2) + 1;
        int year = c.get(1) % 100;
        byte hourField = (byte)(hours & 0x1F);
        if (!options.isIgnoreDaylightSavingTime() && c.get(16) > 0) {
            hourField = (byte)(hourField | 0x80);
        }
        out.writeShort(ms);
        out.writeByte(minutes);
        out.writeByte((int)hourField);
        out.writeByte(dayOfMonth);
        out.writeByte(month);
        out.writeByte(year);
    }

    static long parseTimestamp(ProtocolOptions options, ByteBuf data) {
        int ms = data.readUnsignedShort();
        int minutes = data.readUnsignedByte();
        minutes &= 0x3F;
        int hours = data.readUnsignedByte();
        int dayOfMonth = data.readUnsignedByte() & 0x1F;
        int month = data.readUnsignedByte() & 0xF;
        int year = data.readUnsignedByte() & 0x7F;
        GregorianCalendar c = new GregorianCalendar(options.getTimeZone());
        c.set(year += 2000, month - 1, dayOfMonth, hours &= 0x1F, minutes, ms / 1000);
        c.set(14, ms % 1000);
        return c.getTimeInMillis();
    }

    public static void encodeBooleanValue(ProtocolOptions options, ByteBuf out, Value<Boolean> value, boolean withTimestamp) {
        byte siq = (byte)(value.getValue() != false ? 1 : 0);
        siq = value.getQualityInformation().apply(siq);
        out.writeByte((int)siq);
        if (withTimestamp) {
            TypeHelper.encodeTimestamp(options, out, value.getTimestamp());
        }
    }

    public static void encodeDoublePointValue(ProtocolOptions options, ByteBuf out, Value<DoublePoint> value, boolean withTimestamp) {
        byte diq = (byte)(value.getValue().ordinal() & 3);
        diq = value.getQualityInformation().apply(diq);
        out.writeByte((int)diq);
        if (withTimestamp) {
            TypeHelper.encodeTimestamp(options, out, value.getTimestamp());
        }
    }

    public static Value<Boolean> parseBooleanValue(ProtocolOptions options, ByteBuf data, boolean withTimestamp) {
        byte siq = data.readByte();
        Boolean value = (siq & 1) > 0 ? Boolean.TRUE : Boolean.FALSE;
        QualityInformation qualityInformation = QualityInformation.parse(siq);
        long timestamp = withTimestamp ? TypeHelper.parseTimestamp(options, data) : System.currentTimeMillis();
        return new Value<Boolean>(value, timestamp, qualityInformation);
    }

    public static Value<DoublePoint> parseDoublePointValue(ProtocolOptions options, ByteBuf data, boolean withTimestamp) {
        byte diq = data.readByte();
        DoublePoint value = DoublePoint.values()[diq & 3];
        QualityInformation qualityInformation = QualityInformation.parse(diq);
        long timestamp = withTimestamp ? TypeHelper.parseTimestamp(options, data) : System.currentTimeMillis();
        return new Value<DoublePoint>(value, timestamp, qualityInformation);
    }

    public static void encodeFloatValue(ProtocolOptions options, ByteBuf out, Value<Float> value, boolean withTimestamp) {
        byte qds = (byte)(value.isOverflow() ? 1 : 0);
        byte siq = value.getQualityInformation().apply(qds);
        out.writeFloat(value.getValue().floatValue());
        out.writeByte((int)siq);
        if (withTimestamp) {
            TypeHelper.encodeTimestamp(options, out, value.getTimestamp());
        }
    }

    public static Value<Float> parseFloatValue(ProtocolOptions options, ByteBuf data, boolean withTimestamp) {
        float value = data.readFloat();
        byte qds = data.readByte();
        QualityInformation qualityInformation = QualityInformation.parse(qds);
        boolean overflow = (qds & 1) > 0;
        long timestamp = withTimestamp ? TypeHelper.parseTimestamp(options, data) : System.currentTimeMillis();
        return new Value<Float>(Float.valueOf(value), timestamp, qualityInformation, overflow);
    }

    public static void encodeScaledValue(ProtocolOptions options, ByteBuf out, Value<Short> value, boolean withTimestamp) {
        byte qds = (byte)(value.isOverflow() ? 1 : 0);
        byte siq = value.getQualityInformation().apply(qds);
        out.writeShort((int)value.getValue().shortValue());
        out.writeByte((int)siq);
        if (withTimestamp) {
            TypeHelper.encodeTimestamp(options, out, value.getTimestamp());
        }
    }

    public static Value<Short> parseScaledValue(ProtocolOptions options, ByteBuf data, boolean withTimestamp) {
        short value = data.readShort();
        byte qds = data.readByte();
        QualityInformation qualityInformation = QualityInformation.parse(qds);
        boolean overflow = (qds & 1) > 0;
        long timestamp = withTimestamp ? TypeHelper.parseTimestamp(options, data) : System.currentTimeMillis();
        return new Value<Short>(value, timestamp, qualityInformation, overflow);
    }
}

