/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.event;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.StandardCause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilder;

public abstract class AbstractMessageBuilder<T, M>
implements MessageBuilder<T, M> {
    protected ASDUAddress asduAddress;
    protected CauseOfTransmission causeOfTransmission;
    protected final List<InformationEntry<T>> entries = new LinkedList<InformationEntry<T>>();
    private final int maxContinuousSize;
    private final int maxNotContinuousSize;
    private boolean continuous;
    private InformationObjectAddress lastAddress;
    private final Class<T> clazz;
    private final int maxTimestampSize;

    public AbstractMessageBuilder(Class<T> clazz, int maxContinuousSize, int maxNotContinuousSize, int maxTimestampSize) {
        this.clazz = clazz;
        this.maxContinuousSize = maxContinuousSize;
        this.maxNotContinuousSize = maxNotContinuousSize;
        this.maxTimestampSize = maxTimestampSize;
    }

    @Override
    public boolean accepts(Value<?> value) {
        if (value == null || value.getValue() == null) {
            return false;
        }
        return this.clazz.isAssignableFrom(value.getValue().getClass());
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public boolean isWithTimestamps() {
        if (this.maxTimestampSize <= 0 || this.causeOfTransmission == null) {
            return false;
        }
        Cause cause = this.causeOfTransmission.getCause();
        if (cause.getValue() == StandardCause.REQUEST.getValue()) {
            return true;
        }
        return cause.getValue() == StandardCause.SPONTANEOUS.getValue();
    }

    @Override
    public void start(CauseOfTransmission causeOfTransmission, ASDUAddress asduAddress) {
        this.continuous = true;
        this.asduAddress = asduAddress;
        this.causeOfTransmission = causeOfTransmission;
    }

    @Override
    public boolean addEntry(InformationObjectAddress address, Value<T> value) {
        this.validateStart();
        if (this.lastAddress != null && this.lastAddress.getAddress() + 1 != address.getAddress()) {
            this.continuous = false;
        }
        this.entries.add(new InformationEntry(address, value));
        this.lastAddress = address;
        if (this.isWithTimestamps()) {
            return this.entries.size() < this.maxTimestampSize;
        }
        if (this.continuous) {
            return this.entries.size() < this.maxContinuousSize;
        }
        return this.entries.size() < this.maxNotContinuousSize;
    }

    protected void validateStart() {
        if (this.asduAddress == null || this.causeOfTransmission == null) {
            throw new IllegalStateException("start method was never called");
        }
    }

    protected InformationObjectAddress getStartAddress() {
        if (this.entries.isEmpty() || !this.isContinuous()) {
            return null;
        }
        int address = Integer.MAX_VALUE;
        for (InformationEntry<T> entry : this.entries) {
            address = Math.min(address, entry.getAddress().getAddress());
        }
        return InformationObjectAddress.valueOf((int)address);
    }

    protected List<Value<T>> getValues() {
        ArrayList<Value<T>> result = new ArrayList<Value<T>>(this.entries.size());
        for (InformationEntry<T> entry : this.entries) {
            result.add(entry.getValue());
        }
        return result;
    }
}

