/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.concurrent.internal.FutureTaskNotifier;

public abstract class AbstractFuture<T>
implements NotifyFuture<T> {
    private final FutureTaskNotifier<T> notifier;
    private volatile Throwable error;
    private volatile T result;
    private volatile State state = State.WAITING;
    private final Semaphore lock;
    private final Object setLock;

    public AbstractFuture() {
        this.notifier = new FutureTaskNotifier(this);
        this.lock = new Semaphore(-1);
        this.setLock = new Object();
    }

    @Override
    public void addListener(FutureListener<T> listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void addListener(Runnable listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void removeListener(FutureListener<T> listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public void removeListener(Runnable listener) {
        this.notifier.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResult(T result) {
        Object object = this.setLock;
        synchronized (object) {
            if (this.isDone()) {
                return;
            }
            this.result = result;
            this.state = State.COMPLETE;
            this.lock.release(2);
        }
        this.notifier.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(Throwable error) {
        Object object = this.setLock;
        synchronized (object) {
            if (this.isDone()) {
                return;
            }
            this.error = error;
            this.state = State.COMPLETE;
            this.lock.release(2);
        }
        this.notifier.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.setLock;
        synchronized (object) {
            block4: {
                if (!this.isDone()) break block4;
                return false;
            }
            this.state = State.CANCELED;
            this.lock.release(2);
        }
        this.notifier.done();
        return true;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.lock.acquire(0);
        return this.fetchResult();
    }

    protected T fetchResult() throws ExecutionException {
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (this.error != null) {
            throw new ExecutionException(this.error);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.lock.tryAcquire(0, timeout, unit)) {
            throw new TimeoutException();
        }
        return this.fetchResult();
    }

    @Override
    public boolean isCancelled() {
        return this.state == State.CANCELED;
    }

    @Override
    public boolean isDone() {
        State state = this.state;
        return state == State.CANCELED || state == State.COMPLETE;
    }

    private static enum State {
        WAITING,
        COMPLETE,
        CANCELED;

    }
}

