/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.iec60870server;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelIec60870serverSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_IEC60870SERVER_PATH_URI_PATH_CONF = "camel.sink.path.uriPath";
    public static final String CAMEL_SINK_IEC60870SERVER_PATH_URI_PATH_DOC = "The object information address";
    public static final String CAMEL_SINK_IEC60870SERVER_PATH_URI_PATH_DEFAULT = null;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_DATA_MODULE_OPTIONS_CONF = "camel.sink.endpoint.dataModuleOptions";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_DATA_MODULE_OPTIONS_DOC = "Data module options";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_DATA_MODULE_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_FILTER_NON_EXECUTE_CONF = "camel.sink.endpoint.filterNonExecute";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_FILTER_NON_EXECUTE_DOC = "Filter out all requests which don't have the execute bit set";
    public static final Boolean CAMEL_SINK_IEC60870SERVER_ENDPOINT_FILTER_NON_EXECUTE_DEFAULT = true;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_PROTOCOL_OPTIONS_CONF = "camel.sink.endpoint.protocolOptions";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_PROTOCOL_OPTIONS_DOC = "Protocol options";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_PROTOCOL_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_IEC60870SERVER_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_IEC60870SERVER_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_IEC60870SERVER_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_ACKNOWLEDGE_WINDOW_CONF = "camel.sink.endpoint.acknowledgeWindow";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_ACKNOWLEDGE_WINDOW_DOC = "Parameter W - Acknowledgment window.";
    public static final Short CAMEL_SINK_IEC60870SERVER_ENDPOINT_ACKNOWLEDGE_WINDOW_DEFAULT = 10;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_ADSU_ADDRESS_TYPE_CONF = "camel.sink.endpoint.adsuAddressType";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_ADSU_ADDRESS_TYPE_DOC = "The common ASDU address size. May be either SIZE_1 or SIZE_2. One of: [SIZE_1] [SIZE_2]";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_ADSU_ADDRESS_TYPE_DEFAULT = null;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_OF_TRANSMISSION_TYPE_CONF = "camel.sink.endpoint.causeOfTransmissionType";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_OF_TRANSMISSION_TYPE_DOC = "The cause of transmission type. May be either SIZE_1 or SIZE_2. One of: [SIZE_1] [SIZE_2]";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_OF_TRANSMISSION_TYPE_DEFAULT = null;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_INFORMATION_OBJECT_ADDRESS_TYPE_CONF = "camel.sink.endpoint.informationObjectAddressType";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_INFORMATION_OBJECT_ADDRESS_TYPE_DOC = "The information address size. May be either SIZE_1, SIZE_2 or SIZE_3. One of: [SIZE_1] [SIZE_2] [SIZE_3]";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_INFORMATION_OBJECT_ADDRESS_TYPE_DEFAULT = null;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_MAX_UNACKNOWLEDGED_CONF = "camel.sink.endpoint.maxUnacknowledged";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_MAX_UNACKNOWLEDGED_DOC = "Parameter K - Maximum number of un-acknowledged messages.";
    public static final Short CAMEL_SINK_IEC60870SERVER_ENDPOINT_MAX_UNACKNOWLEDGED_DEFAULT = 15;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_1CONF = "camel.sink.endpoint.timeout1";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_1DOC = "Timeout T1 in milliseconds.";
    public static final Integer CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_1DEFAULT = 15000;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_2CONF = "camel.sink.endpoint.timeout2";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_2DOC = "Timeout T2 in milliseconds.";
    public static final Integer CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_2DEFAULT = 10000;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_3CONF = "camel.sink.endpoint.timeout3";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_3DOC = "Timeout T3 in milliseconds.";
    public static final Integer CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_3DEFAULT = 20000;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_SOURCE_ADDRESS_CONF = "camel.sink.endpoint.causeSourceAddress";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_SOURCE_ADDRESS_DOC = "Whether to include the source address";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_SOURCE_ADDRESS_DEFAULT = null;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_TIMEOUT_CONF = "camel.sink.endpoint.connectionTimeout";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_TIMEOUT_DOC = "Timeout in millis to wait for client to establish a connected connection.";
    public static final Integer CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_TIMEOUT_DEFAULT = 10000;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_BACKGROUND_SCAN_CONF = "camel.sink.endpoint.ignoreBackgroundScan";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_BACKGROUND_SCAN_DOC = "Whether background scan transmissions should be ignored.";
    public static final Boolean CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_BACKGROUND_SCAN_DEFAULT = true;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_DAYLIGHT_SAVING_TIME_CONF = "camel.sink.endpoint.ignoreDaylightSavingTime";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_DAYLIGHT_SAVING_TIME_DOC = "Whether to ignore or respect DST";
    public static final Boolean CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_DAYLIGHT_SAVING_TIME_DEFAULT = false;
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIME_ZONE_CONF = "camel.sink.endpoint.timeZone";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIME_ZONE_DOC = "The timezone to use. May be any Java time zone string";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIME_ZONE_DEFAULT = "UTC";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_ID_CONF = "camel.sink.endpoint.connectionId";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_ID_DOC = "An identifier grouping connection instances";
    public static final String CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_ID_DEFAULT = null;
    public static final String CAMEL_SINK_IEC60870SERVER_COMPONENT_DEFAULT_CONNECTION_OPTIONS_CONF = "camel.component.iec60870-server.defaultConnectionOptions";
    public static final String CAMEL_SINK_IEC60870SERVER_COMPONENT_DEFAULT_CONNECTION_OPTIONS_DOC = "Default connection options";
    public static final String CAMEL_SINK_IEC60870SERVER_COMPONENT_DEFAULT_CONNECTION_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SINK_IEC60870SERVER_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.iec60870-server.lazyStartProducer";
    public static final String CAMEL_SINK_IEC60870SERVER_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_IEC60870SERVER_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_IEC60870SERVER_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.iec60870-server.basicPropertyBinding";
    public static final String CAMEL_SINK_IEC60870SERVER_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_IEC60870SERVER_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;

    public CamelIec60870serverSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelIec60870serverSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_IEC60870SERVER_PATH_URI_PATH_CONF, ConfigDef.Type.STRING, CAMEL_SINK_IEC60870SERVER_PATH_URI_PATH_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_IEC60870SERVER_PATH_URI_PATH_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_DATA_MODULE_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_IEC60870SERVER_ENDPOINT_DATA_MODULE_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_DATA_MODULE_OPTIONS_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_FILTER_NON_EXECUTE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_IEC60870SERVER_ENDPOINT_FILTER_NON_EXECUTE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_FILTER_NON_EXECUTE_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_PROTOCOL_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_IEC60870SERVER_ENDPOINT_PROTOCOL_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_PROTOCOL_OPTIONS_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_IEC60870SERVER_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_IEC60870SERVER_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_IEC60870SERVER_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_ACKNOWLEDGE_WINDOW_CONF, ConfigDef.Type.SHORT, CAMEL_SINK_IEC60870SERVER_ENDPOINT_ACKNOWLEDGE_WINDOW_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_ACKNOWLEDGE_WINDOW_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_ADSU_ADDRESS_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_IEC60870SERVER_ENDPOINT_ADSU_ADDRESS_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_ADSU_ADDRESS_TYPE_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_OF_TRANSMISSION_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_OF_TRANSMISSION_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_OF_TRANSMISSION_TYPE_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_INFORMATION_OBJECT_ADDRESS_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_IEC60870SERVER_ENDPOINT_INFORMATION_OBJECT_ADDRESS_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_INFORMATION_OBJECT_ADDRESS_TYPE_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_MAX_UNACKNOWLEDGED_CONF, ConfigDef.Type.SHORT, CAMEL_SINK_IEC60870SERVER_ENDPOINT_MAX_UNACKNOWLEDGED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_MAX_UNACKNOWLEDGED_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_1CONF, ConfigDef.Type.INT, CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_1DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_1DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_2CONF, ConfigDef.Type.INT, CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_2DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_2DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_3CONF, ConfigDef.Type.INT, CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_3DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIMEOUT_3DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_SOURCE_ADDRESS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_SOURCE_ADDRESS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_CAUSE_SOURCE_ADDRESS_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.INT, CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_BACKGROUND_SCAN_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_BACKGROUND_SCAN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_BACKGROUND_SCAN_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_DAYLIGHT_SAVING_TIME_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_DAYLIGHT_SAVING_TIME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_IGNORE_DAYLIGHT_SAVING_TIME_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIME_ZONE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIME_ZONE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_TIME_ZONE_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_ID_CONF, ConfigDef.Type.STRING, CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_ENDPOINT_CONNECTION_ID_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_COMPONENT_DEFAULT_CONNECTION_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_IEC60870SERVER_COMPONENT_DEFAULT_CONNECTION_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_COMPONENT_DEFAULT_CONNECTION_OPTIONS_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_IEC60870SERVER_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_IEC60870SERVER_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_IEC60870SERVER_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_IEC60870SERVER_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SINK_IEC60870SERVER_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        return conf;
    }
}