/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.types;

import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;

public enum StandardCause implements Cause
{
    INVALID(0, null),
    PERIODIC(1, "per/cyc"),
    BACKGROUND(2, "back"),
    SPONTANEOUS(3, "spont"),
    INITIAL(4, "init"),
    REQUEST(5, "req"),
    ACTIVATED(6, "act"),
    ACTIVATION_CONFIRM(7, "actcon"),
    DEACTIVATED(8, "deact"),
    DEACTIVATION_CONFIRM(9, "deactcon"),
    ACTIVATION_TERMINATION(10, "actterm"),
    RETURN_REMOTE(11, "retrem"),
    RETURN_LOCAL(12, "retloc"),
    FILE_TRANSMISSION(13, "file"),
    STATION_REQUEST(20, "inrogen"),
    GROUP_REQUEST_1(21, "inro1"),
    GROUP_REQUEST_2(22, "inro2"),
    GROUP_REQUEST_3(23, "inro3"),
    GROUP_REQUEST_4(24, "inro4"),
    GROUP_REQUEST_5(25, "inro5"),
    GROUP_REQUEST_6(26, "inro6"),
    GROUP_REQUEST_7(27, "inro7"),
    GROUP_REQUEST_8(28, "inro8"),
    GROUP_REQUEST_9(29, "inro9"),
    GROUP_REQUEST_10(30, "inro10"),
    GROUP_REQUEST_11(31, "inro11"),
    GROUP_REQUEST_12(32, "inro12"),
    GROUP_REQUEST_13(33, "inro13"),
    GROUP_REQUEST_14(34, "inro14"),
    GROUP_REQUEST_15(35, "inro15"),
    GROUP_REQUEST_16(36, "inro16"),
    COUNTER_GENERAL(37, "reqcogen"),
    COUNTER_GROUP_1(38, "reqco1"),
    COUNTER_GROUP_2(39, "reqco2"),
    COUNTER_GROUP_3(40, "reqco3"),
    COUNTER_GROUP_4(41, "reqco4"),
    UNKNOWN_TYPE(44, null),
    UNKNOWN_REASON(45, null),
    UNKNOWN_ASDU_ADDRESS(46, null),
    UNKNOWN_INFORMATION_OBJECT_ADDRESS(47, null);

    private short value;
    private String label;

    private StandardCause(short value, String label) {
        this.value = value;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.label != null ? String.format("[%s:%s]", this.value, this.label) : String.format("[%s]", this.value);
    }

    @Override
    public short getValue() {
        return this.value;
    }
}

