/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.event;

import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledSequence;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MeasuredValueScaledTimeSingle;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.AbstractMessageBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilderFactory;

public class SimpleScaledBuilder
implements MessageBuilderFactory<Short> {
    private final boolean withTimestamps;

    public SimpleScaledBuilder(boolean withTimestamps) {
        this.withTimestamps = withTimestamps;
    }

    @Override
    public MessageBuilder<Short, ?> create() {
        return new AbstractMessageBuilder<Short, Object>(Short.class, 20, 20, this.withTimestamps ? 10 : -1){

            @Override
            public Object build() {
                this.validateStart();
                ASDUHeader header = new ASDUHeader(this.causeOfTransmission, this.asduAddress);
                if (this.isWithTimestamps()) {
                    return MeasuredValueScaledTimeSingle.create((ASDUHeader)header, (List)this.entries);
                }
                if (this.isContinuous()) {
                    return MeasuredValueScaledSequence.create((InformationObjectAddress)this.getStartAddress(), (ASDUHeader)header, this.getValues());
                }
                return MeasuredValueScaledSingle.create((ASDUHeader)header, (List)this.entries);
            }
        };
    }
}

