/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.neoscada.protocol.iec60870.apci.MessageChannel;
import org.eclipse.neoscada.protocol.iec60870.apci.MessageSource;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.DataTransmissionMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.InterrogationCommand;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.MirrorableMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.ReadCommand;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SetPointCommandScaledValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SetPointCommandShortFloatingPoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.SingleCommand;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.StandardCause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.io.AbstractModuleHandler;
import org.eclipse.neoscada.protocol.iec60870.io.MirrorCommand;
import org.eclipse.neoscada.protocol.iec60870.server.data.ContextChannelWriter;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataListenerImpl;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModuleMessageSource;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataModuleOptions;
import org.eclipse.neoscada.protocol.iec60870.server.data.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataModuleHandler
extends AbstractModuleHandler {
    private static final Logger logger = LoggerFactory.getLogger(DataModuleHandler.class);
    private final DataModel dataModel;
    private Subscription subscription;
    private ChannelHandlerContext ctx;
    private final boolean spontaneous;
    private DataListenerImpl spontHandler;
    private final MessageChannel messageChannel;
    private DataModuleMessageSource source;
    private boolean subscribed;
    private final int backgroundScanPeriod;
    private final DataModuleOptions options;

    public DataModuleHandler(DataModuleOptions options, MessageChannel messageChannel, DataModel dataModel) {
        this.options = options;
        this.messageChannel = messageChannel;
        this.dataModel = dataModel;
        this.spontaneous = options.isSpontaneous();
        this.backgroundScanPeriod = options.getBackgroundScanPeriod();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        logger.debug("Channel active - {}", (Object)ctx);
        this.ctx = ctx;
        this.source = new DataModuleMessageSource(this.options, (ScheduledExecutorService)ctx.executor(), new ContextChannelWriter(ctx), this.dataModel, this.backgroundScanPeriod);
        this.messageChannel.addSource((MessageSource)this.source);
        this.spontHandler = new DataListenerImpl(this.source, new CauseOfTransmission((Cause)StandardCause.SPONTANEOUS));
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.stopSubscription(null);
        super.channelInactive(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        logger.debug("channelRead - msg: {}, ctx: {}", msg, (Object)ctx);
        try {
            if (msg == DataTransmissionMessage.REQUEST_START) {
                this.startDataTransmission(ctx);
            } else if (msg == DataTransmissionMessage.REQUEST_STOP) {
                this.stopDataTransmission(ctx);
            } else if (msg instanceof ReadCommand) {
                this.handleReadCommand(ctx, (ReadCommand)msg);
            } else if (msg instanceof InterrogationCommand) {
                this.handleInterrogationCommand(ctx, (InterrogationCommand)msg);
            } else if (msg instanceof SingleCommand) {
                this.handleWriteCommand(ctx, (SingleCommand)msg);
            } else if (msg instanceof SetPointCommandShortFloatingPoint) {
                this.handleWriteValue(ctx, (SetPointCommandShortFloatingPoint)msg);
            } else if (msg instanceof SetPointCommandScaledValue) {
                this.handleWriteValue(ctx, (SetPointCommandScaledValue)msg);
            } else {
                ctx.fireChannelRead(msg);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to process message", (Throwable)e);
            throw new InvocationTargetException(e);
        }
    }

    private void handleWriteCommand(ChannelHandlerContext ctx, SingleCommand msg) {
        AbstractModuleHandler.DefaultMirrorCommand mc = new AbstractModuleHandler.DefaultMirrorCommand((AbstractModuleHandler)this, ctx, (MirrorableMessage)msg);
        this.dataModel.writeCommand(msg.getHeader(), msg.getInformationObjectAddress(), msg.getState(), msg.getType(), (MirrorCommand)mc, msg.isExecute());
    }

    private void handleWriteValue(ChannelHandlerContext ctx, SetPointCommandShortFloatingPoint msg) {
        AbstractModuleHandler.DefaultMirrorCommand mc = new AbstractModuleHandler.DefaultMirrorCommand((AbstractModuleHandler)this, ctx, (MirrorableMessage)msg);
        this.dataModel.writeFloatValue(msg.getHeader(), msg.getInformationObjectAddress(), msg.getValue(), msg.getType(), (MirrorCommand)mc, msg.isExecute());
    }

    private void handleWriteValue(ChannelHandlerContext ctx, SetPointCommandScaledValue msg) {
        AbstractModuleHandler.DefaultMirrorCommand mc = new AbstractModuleHandler.DefaultMirrorCommand((AbstractModuleHandler)this, ctx, (MirrorableMessage)msg);
        this.dataModel.writeScaledValue(msg.getHeader(), msg.getInformationObjectAddress(), msg.getValue(), msg.getType(), (MirrorCommand)mc, msg.isExecute());
    }

    private void stopDataTransmission(ChannelHandlerContext ctx) {
        this.stopSubscription(ctx);
    }

    private void startDataTransmission(ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)DataTransmissionMessage.CONFIRM_START);
        if (this.spontaneous) {
            this.startSubscription(ctx);
            logger.debug("Started subscription");
        } else {
            logger.debug("Started subscription (fake)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSubscription(ChannelHandlerContext ctx) {
        logger.info("Start subscription - active: {}", (Object)(this.subscription != null ? 1 : 0));
        DataModuleHandler dataModuleHandler = this;
        synchronized (dataModuleHandler) {
            if (this.subscribed) {
                return;
            }
            this.subscribed = true;
        }
        this.subscription = this.dataModel.subscribe(this.spontHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSubscription(final ChannelHandlerContext ctx) {
        Subscription subscription;
        logger.info("Stop subscription - active: {}", (Object)(this.subscription != null ? 1 : 0));
        DataModuleHandler dataModuleHandler = this;
        synchronized (dataModuleHandler) {
            if (!this.subscribed) {
                return;
            }
            this.subscribed = false;
            subscription = this.subscription;
            this.subscription = null;
        }
        if (subscription == null) {
            if (ctx != null) {
                ctx.writeAndFlush((Object)DataTransmissionMessage.CONFIRM_STOP);
            }
            return;
        }
        ListenableFuture<Void> future = subscription.dispose();
        if (ctx != null) {
            Futures.addCallback(future, (FutureCallback)new AbstractModuleHandler.CloseOnFailureCallback(this, ctx){

                public void onSuccess(Void result) {
                    ctx.writeAndFlush((Object)DataTransmissionMessage.CONFIRM_STOP);
                }
            });
        }
    }

    private void handleReadCommand(ChannelHandlerContext ctx, ReadCommand msg) {
        logger.debug("Handle read command");
        if (msg.getHeader().getCauseOfTransmission().getCause() != StandardCause.REQUEST) {
            ctx.writeAndFlush((Object)msg.mirror((Cause)StandardCause.UNKNOWN_REASON, true));
            return;
        }
        final InformationObjectAddress address = msg.getInformationObjectAddress();
        final ASDUHeader header = msg.getHeader();
        ListenableFuture<Value<?>> result = this.dataModel.read(header.getAsduAddress(), address);
        if (result != null) {
            Futures.addCallback(result, (FutureCallback)new FutureCallback<Value<?>>(){

                public void onSuccess(Value<?> result) {
                    DataModuleHandler.this.handleReadCommandComplete(header, address, result);
                }

                public void onFailure(Throwable t) {
                    DataModuleHandler.this.handleReadFailure(header, address, t);
                }
            });
        } else {
            this.handleReadFailure(header, address, null);
        }
    }

    protected void handleReadFailure(ASDUHeader originalHeader, InformationObjectAddress address, Throwable t) {
        this.ctx.writeAndFlush((Object)new ReadCommand(originalHeader.clone((Cause)StandardCause.UNKNOWN_INFORMATION_OBJECT_ADDRESS), address));
    }

    protected void handleReadCommandComplete(ASDUHeader originalHeader, InformationObjectAddress address, Value<?> result) {
        if (result == null) {
            this.ctx.writeAndFlush((Object)new ReadCommand(originalHeader.clone((Cause)StandardCause.UNKNOWN_INFORMATION_OBJECT_ADDRESS), address));
            return;
        }
        ASDUHeader header = originalHeader.clone((Cause)StandardCause.REQUEST);
        Object value = result.getValue();
        if (value instanceof Boolean) {
            this.source.sendBooleanValue(header, address, result);
        } else if (value instanceof Float) {
            this.source.sendFloatValue(header, address, result);
        } else {
            this.handleReadFailure(originalHeader, address, null);
        }
    }

    private void handleInterrogationCommand(ChannelHandlerContext ctx, InterrogationCommand msg) {
        logger.debug("Handle interrogation command");
        this.source.startInterrogation(msg);
    }
}

