/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.script;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.scada.utils.script.Scripts;

public class ScriptExecutor {
    private static final String PROP_NAME_DISABLE_COMPILE = "org.eclipse.scada.utils.script.ScriptExecutor.disableCompile";
    private final ScriptEngine engine;
    private final String command;
    private CompiledScript compiledScript;
    private final ClassLoader classLoader;
    private final URL commandUrl;
    private final String sourceName;

    public ScriptExecutor(String engineName, String command, ClassLoader classLoader) throws Exception {
        this(engineName, command, classLoader, null);
    }

    public ScriptExecutor(String engineName, String command, ClassLoader classLoader, String sourceName) throws Exception {
        this(Scripts.createManager(classLoader), engineName, command, classLoader, sourceName);
    }

    public ScriptExecutor(String engineName, URL commandUrl, ClassLoader classLoader) throws Exception {
        this(Scripts.createManager(classLoader), engineName, commandUrl, classLoader);
    }

    public ScriptExecutor(ScriptEngineManager engineManager, String engineName, String command, ClassLoader classLoader) throws Exception {
        this(Scripts.createEngine(engineManager, engineName, classLoader), engineName == null ? null : command, classLoader);
    }

    public ScriptExecutor(ScriptEngineManager engineManager, String engineName, String command, ClassLoader classLoader, String sourceName) throws Exception {
        this(Scripts.createEngine(engineManager, engineName, classLoader), engineName == null ? null : command, classLoader, sourceName);
    }

    public ScriptExecutor(ScriptEngineManager engineManager, String engineName, URL commandUrl, ClassLoader classLoader) throws Exception {
        this(Scripts.createEngine(engineManager, engineName, classLoader), engineName == null ? null : commandUrl, classLoader);
    }

    public ScriptExecutor(final ScriptEngine engine, final String command, ClassLoader classLoader, String sourceName) throws Exception {
        this.engine = engine;
        this.command = command;
        this.commandUrl = null;
        this.classLoader = classLoader;
        this.sourceName = sourceName;
        if (command != null && engine instanceof Compilable && !Boolean.getBoolean(PROP_NAME_DISABLE_COMPILE)) {
            if (sourceName != null) {
                engine.put("javax.script.filename", sourceName);
            }
            Scripts.executeWithClassLoader(classLoader, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ScriptExecutor.this.compiledScript = ((Compilable)((Object)engine)).compile(command);
                    return null;
                }
            });
        }
    }

    public ScriptExecutor(ScriptEngine engine, String command, ClassLoader classLoader) throws Exception {
        this(engine, command, classLoader, null);
    }

    public ScriptExecutor(final ScriptEngine engine, final URL commandUrl, ClassLoader classLoader) throws Exception {
        this.engine = engine;
        this.command = null;
        this.commandUrl = commandUrl;
        this.classLoader = classLoader;
        this.sourceName = commandUrl.toString();
        if (commandUrl != null && engine instanceof Compilable && !Boolean.getBoolean(PROP_NAME_DISABLE_COMPILE)) {
            Scripts.executeWithClassLoader(classLoader, new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ScriptExecutor.this.compiledScript = ((Compilable)((Object)engine)).compile(new InputStreamReader(commandUrl.openStream()));
                    return null;
                }
            });
        }
    }

    protected Map<String, Object> applyVars(ScriptContext context, Map<String, Object> scriptObjects) {
        if (scriptObjects == null || scriptObjects.isEmpty()) {
            return null;
        }
        HashMap<String, Object> replaced = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : scriptObjects.entrySet()) {
            Object original = context.getAttribute(entry.getKey(), 100);
            replaced.put(entry.getKey(), original);
            context.setAttribute(entry.getKey(), entry.getValue(), 100);
        }
        return replaced;
    }

    protected void restoreVars(ScriptContext context, Map<String, Object> vars) {
        if (vars == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : vars.entrySet()) {
            if (entry.getValue() == null) {
                context.removeAttribute(entry.getKey(), 100);
                continue;
            }
            context.setAttribute(entry.getKey(), entry.getValue(), 100);
        }
    }

    private Object executeScript(ScriptContext scriptContext, Map<String, Object> scriptObjects) throws ScriptException, IOException {
        if (this.command == null && this.commandUrl == null && this.compiledScript == null) {
            return null;
        }
        Map<String, Object> vars = null;
        try {
            if (this.sourceName != null) {
                this.engine.put("javax.script.filename", this.sourceName);
            }
            vars = this.applyVars(scriptContext, scriptObjects);
            if (this.compiledScript != null) {
                Object object = this.compiledScript.eval(scriptContext);
                return object;
            }
            if (this.command != null) {
                Object object = this.engine.eval(this.command, scriptContext);
                return object;
            }
            if (this.commandUrl != null) {
                Throwable throwable = null;
                Object var5_9 = null;
                try (InputStreamReader reader = new InputStreamReader(this.commandUrl.openStream());){
                    Object object = this.engine.eval((Reader)reader, scriptContext);
                    this.restoreVars(scriptContext, vars);
                    return object;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return null;
        }
        finally {
            this.restoreVars(scriptContext, vars);
        }
    }

    public Object execute(ScriptContext scriptContext) throws Exception {
        return this.execute(scriptContext, null);
    }

    public Object execute(final ScriptContext scriptContext, final Map<String, Object> scriptObjects) throws Exception {
        return Scripts.executeWithClassLoader(this.classLoader, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ScriptExecutor.this.executeScript(scriptContext, scriptObjects);
            }
        });
    }

    public String toString() {
        if (this.compiledScript != null) {
            return this.compiledScript.toString();
        }
        return this.command;
    }
}

