/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.JsonDataFormat;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.reifier.dataformat.DataFormatReifier;

public class JsonDataFormatReifier
extends DataFormatReifier<JsonDataFormat> {
    public JsonDataFormatReifier(CamelContext camelContext, DataFormatDefinition definition) {
        super(camelContext, (JsonDataFormat)definition);
    }

    @Override
    protected void prepareDataFormatConfig(Map<String, Object> properties) {
        properties.put("objectMapper", this.asRef(((JsonDataFormat)this.definition).getObjectMapper()));
        properties.put("useDefaultObjectMapper", ((JsonDataFormat)this.definition).getUseDefaultObjectMapper());
        properties.put("unmarshalType", this.or(((JsonDataFormat)this.definition).getUnmarshalType(), ((JsonDataFormat)this.definition).getUnmarshalTypeName()));
        properties.put("prettyPrint", ((JsonDataFormat)this.definition).getPrettyPrint());
        properties.put("jsonView", ((JsonDataFormat)this.definition).getJsonView());
        properties.put("include", ((JsonDataFormat)this.definition).getInclude());
        properties.put("allowJmsType", ((JsonDataFormat)this.definition).getAllowJmsType());
        properties.put("collectionType", this.or(((JsonDataFormat)this.definition).getCollectionType(), ((JsonDataFormat)this.definition).getCollectionTypeName()));
        properties.put("useList", ((JsonDataFormat)this.definition).getUseList());
        properties.put("enableJaxbAnnotationModule", ((JsonDataFormat)this.definition).getEnableJaxbAnnotationModule());
        properties.put("moduleClassNames", ((JsonDataFormat)this.definition).getModuleClassNames());
        properties.put("moduleRefs", ((JsonDataFormat)this.definition).getModuleRefs());
        properties.put("enableFeatures", ((JsonDataFormat)this.definition).getEnableFeatures());
        properties.put("disableFeatures", ((JsonDataFormat)this.definition).getDisableFeatures());
        properties.put("allowUnmarshallType", ((JsonDataFormat)this.definition).getAllowUnmarshallType());
        if (((JsonDataFormat)this.definition).getLibrary() == JsonLibrary.XStream && ((JsonDataFormat)this.definition).getPermissions() == null) {
            String type = ((JsonDataFormat)this.definition).getUnmarshalTypeName();
            if (type == null && ((JsonDataFormat)this.definition).getUnmarshalType() != null) {
                type = ((JsonDataFormat)this.definition).getUnmarshalType().getName();
            }
            properties.put("permissions", type);
            properties.remove("unmarshalType");
        }
    }
}

