/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.apci.InformationTransfer;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.MessageCodec;
import org.eclipse.neoscada.protocol.iec60870.asdu.ReflectionMessageCodec;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.EncodeHelper;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.StandardCause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageManager {
    private static final Logger logger = LoggerFactory.getLogger(MessageManager.class);
    private final Map<MessageTypeId, MessageCodec> codecs = new ConcurrentHashMap<MessageTypeId, MessageCodec>();
    private final ProtocolOptions options;

    public MessageManager(ProtocolOptions options) {
        this.options = options;
    }

    public ByteBuf receiveMessage(InformationTransfer informationTransfer, List<Object> out) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received message: {} -> {}", (Object)informationTransfer, informationTransfer.getData() != null ? ByteBufUtil.hexDump((ByteBuf)informationTransfer.getData()) : null);
        }
        ByteBuf data = informationTransfer.getData();
        byte typeId = data.readByte();
        byte subTypeId = data.readByte();
        InformationStructure informationStructure = (subTypeId & 0x80) > 0 ? InformationStructure.SEQUENCE : InformationStructure.SINGLE;
        byte length = (byte)(0xFFFFFF7F & subTypeId);
        CauseOfTransmission causeOfTransmission = CauseOfTransmission.parse(this.options, data);
        ASDUAddress asduAddress = ASDUAddress.parse(this.options, data);
        ASDUHeader header = new ASDUHeader(causeOfTransmission, asduAddress);
        MessageCodec codec = this.codecs.get(MessageTypeId.valueOf(typeId, informationStructure));
        if (codec == null) {
            return this.mirrorUnknown(data, typeId, informationStructure, length, header, StandardCause.UNKNOWN_TYPE);
        }
        out.add(codec.parse(this.options, length, header, data));
        return null;
    }

    private ByteBuf mirrorUnknown(ByteBuf data, byte typeId, InformationStructure informationStructure, byte size, ASDUHeader header, Cause newCause) {
        logger.debug("Mirror unknown message -> {}", (Object)newCause);
        ByteBuf reply = Unpooled.buffer();
        EncodeHelper.encodeHeader(typeId, informationStructure, this.options, Integer.valueOf(size), header.clone(newCause), reply);
        reply.writeBytes(data);
        return reply;
    }

    public void encodeMessage(Object msg, ByteBuf buf) {
        logger.debug("Encode message: {}", msg);
        ASDU asdu = msg.getClass().getAnnotation(ASDU.class);
        if (asdu == null) {
            throw new IllegalStateException(String.format("Unable to send message of type %s, no %s annotation found", msg.getClass(), ASDU.class.getName()));
        }
        MessageCodec codec = this.codecs.get(new MessageTypeId(asdu.id(), asdu.informationStructure()));
        if (codec == null) {
            throw new IllegalStateException(String.format("Unable to send message of type %s, no codec is registered", msg.getClass()));
        }
        try {
            buf = buf.order(ByteOrder.LITTLE_ENDIAN);
            codec.encode(this.options, msg, buf);
            logger.debug("Encoded to {} bytes", (Object)buf.writerIndex());
        }
        catch (Exception e) {
            logger.warn("Failed to encode message", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void handleUnknownMessage(byte typeId, ASDUHeader header, ByteBuf data) {
        logger.info("Received unknown message - typeId: {}, header: {}, data: {}", new Object[]{(int)typeId, header, ByteBufUtil.hexDump((ByteBuf)data)});
    }

    protected void registerCodec(MessageTypeId messageTypeId, MessageCodec codec) {
        this.codecs.put(messageTypeId, codec);
    }

    public void registerCodec(byte typeId, InformationStructure informationStructure, MessageCodec codec) {
        this.registerCodec(new MessageTypeId(typeId, informationStructure), codec);
    }

    public <T> void registerClass(Class<T> clazz) {
        MethodHandle encodeMethod;
        MethodHandle parseMethod;
        logger.debug("Registering {}", clazz);
        ASDU asdu = clazz.getAnnotation(ASDU.class);
        if (asdu == null) {
            throw new IllegalArgumentException(String.format("Class %s must have the annotation %s", clazz.getName(), ASDU.class.getName()));
        }
        MethodType parseMethodType = MethodType.methodType(clazz, ProtocolOptions.class, Byte.TYPE, ASDUHeader.class, ByteBuf.class);
        try {
            parseMethod = MethodHandles.lookup().findStatic(clazz, "parse", parseMethodType);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new IllegalArgumentException(String.format("The class %s must have a static method named 'parse' with the signature %s", clazz.getName(), parseMethodType));
        }
        MethodType encodeMethodType = MethodType.methodType(Void.TYPE, ProtocolOptions.class, ByteBuf.class);
        try {
            encodeMethod = MethodHandles.lookup().findVirtual(clazz, "encode", encodeMethodType);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new IllegalArgumentException(String.format("The class %s must have a method named 'encode' with the signature %s", clazz.getName(), encodeMethodType));
        }
        this.registerCodec(new MessageTypeId(asdu.id(), asdu.informationStructure()), new ReflectionMessageCodec<T>(clazz, parseMethod, encodeMethod));
    }

    private static class MessageTypeId {
        private final byte typeId;
        private final InformationStructure informationStructure;

        public MessageTypeId(byte typeId, InformationStructure informationStructure) {
            this.typeId = typeId;
            this.informationStructure = informationStructure;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.informationStructure == null ? 0 : this.informationStructure.hashCode());
            result = 31 * result + this.typeId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageTypeId other = (MessageTypeId)obj;
            if (this.informationStructure != other.informationStructure) {
                return false;
            }
            return this.typeId == other.typeId;
        }

        public static MessageTypeId valueOf(byte typeId, InformationStructure informationStructure) {
            return new MessageTypeId(typeId, informationStructure);
        }
    }
}

