/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationEntry;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.server.data.AbstractBaseDataModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataListener;
import org.eclipse.neoscada.protocol.iec60870.server.data.Subscription;

public class DefaultSubscription
implements Subscription {
    private final AbstractBaseDataModel dataModel;
    private final DataListener listener;

    public DefaultSubscription(AbstractBaseDataModel dataModel, DataListener listener) {
        this.dataModel = dataModel;
        this.listener = listener;
    }

    @Override
    public ListenableFuture<Void> dispose() {
        return this.dataModel.disposeSubscription(this);
    }

    public void notifyChangeBoolean(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Boolean>> values) {
        this.listener.dataChangeBoolean(asduAddress, startAddress, values);
    }

    public void notifyChangeBoolean(ASDUAddress asduAddress, List<InformationEntry<Boolean>> values) {
        this.listener.dataChangeBoolean(asduAddress, values);
    }

    public void notifyChangeFloat(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Float>> values) {
        this.listener.dataChangeFloat(asduAddress, startAddress, values);
    }

    public void notifyChangeFloat(ASDUAddress asduAddress, List<InformationEntry<Float>> values) {
        this.listener.dataChangeFloat(asduAddress, values);
    }

    public void notifyChangeShort(ASDUAddress asduAddress, InformationObjectAddress startAddress, List<Value<Short>> values) {
        this.listener.dataChangeShort(asduAddress, startAddress, values);
    }

    public void notifyChangeShort(ASDUAddress asduAddress, List<InformationEntry<Short>> values) {
        this.listener.dataChangeShort(asduAddress, values);
    }
}

