/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.server.data.testing;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CauseOfTransmission;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.QualityInformation;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.io.MirrorCommand;
import org.eclipse.neoscada.protocol.iec60870.server.data.AbstractBaseDataModel;
import org.eclipse.neoscada.protocol.iec60870.server.data.BackgroundIterator;
import org.eclipse.neoscada.protocol.iec60870.server.data.DataListener;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.MessageBuilder;
import org.eclipse.neoscada.protocol.iec60870.server.data.event.SimpleFloatBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SineDataModel
extends AbstractBaseDataModel {
    private static final SimpleFloatBuilder BUILDER = new SimpleFloatBuilder(false);
    private static final ASDUAddress ASDU_ADDRESS = ASDUAddress.valueOf((int)1);
    private static final Logger logger = LoggerFactory.getLogger(SineDataModel.class);
    private final List<Value<Float>> values;
    private final int size;
    private final InformationObjectAddress startAddress = new InformationObjectAddress(1);

    public SineDataModel(int size) {
        super("SineDataModel");
        this.size = size;
        this.values = new ArrayList<Value<Float>>(size);
        int i = 0;
        while (i < size) {
            this.values.add((Value<Float>)new Value((Object)Float.valueOf(0.0f), System.currentTimeMillis(), QualityInformation.INVALID));
            ++i;
        }
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SineDataModel.this.update();
            }
        }, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    protected synchronized void update() {
        long tix = System.currentTimeMillis();
        int i = 0;
        while (i < this.size) {
            this.values.set(i, (Value<Float>)Value.ok((Object)Float.valueOf((float)Math.sin(Math.toRadians((double)tix / 1000.0)) * (float)i)));
            ++i;
        }
        this.notifyChangeFloat(ASDU_ADDRESS, this.startAddress, this.values);
    }

    @Override
    public ListenableFuture<Value<?>> read(final ASDUAddress asduAddress, final InformationObjectAddress address) {
        if (ASDU_ADDRESS.equals((Object)asduAddress.getAddress())) {
            return null;
        }
        return this.executor.submit(new Callable<Value<?>>(){

            @Override
            public Value<?> call() throws Exception {
                return SineDataModel.this.performRead(asduAddress, address);
            }
        });
    }

    protected synchronized Value<?> performRead(ASDUAddress asduAddress, InformationObjectAddress address) {
        return this.values.get(address.getAddress());
    }

    @Override
    public ListenableFuture<Void> readAll(ASDUAddress asduAddress, Runnable prepare, final DataListener listener) {
        if (asduAddress.getAddress() != 1) {
            return null;
        }
        this.executor.submit(prepare);
        return this.executor.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return SineDataModel.this.performReadAll(listener);
            }
        });
    }

    protected synchronized Void performReadAll(DataListener listener) {
        logger.debug("performReadAll");
        listener.dataChangeFloat(ASDU_ADDRESS, this.startAddress, new ArrayList<Value<Float>>(this.values));
        logger.debug("performReadAll - done");
        return null;
    }

    @Override
    public void forAllAsdu(Consumer<ASDUAddress> function, Runnable ifNoneFound) {
        function.accept(ASDU_ADDRESS);
    }

    @Override
    public BackgroundIterator createBackgroundIterator() {
        return new BackgroundIteratorImpl();
    }

    protected Object proceedBackgroundScan(final AtomicInteger positionRef) {
        int position = positionRef.get();
        if (position >= this.size) {
            return null;
        }
        try {
            return this.executor.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return SineDataModel.this.internalBackgroundScan(positionRef);
                }
            }).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to perform background scan", e);
        }
    }

    private synchronized Object internalBackgroundScan(AtomicInteger positionRef) {
        int position = positionRef.get();
        MessageBuilder<Float, ?> builder = BUILDER.create();
        builder.start(CauseOfTransmission.BACKGROUND, ASDU_ADDRESS);
        while (builder.addEntry(new InformationObjectAddress(this.startAddress.getAddress() + position), this.values.get(position))) {
            ++position;
        }
        positionRef.set(position);
        return builder.build();
    }

    private void performWrite(final MirrorCommand mirrorCommand, boolean execute) {
        mirrorCommand.sendActivationConfirm(true);
        if (execute) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    SineDataModel.this.handleWriteCommand(mirrorCommand);
                }
            });
        }
    }

    @Override
    public void writeCommand(ASDUHeader header, InformationObjectAddress informationObjectAddress, boolean state, byte type, MirrorCommand mirrorCommand, boolean execute) {
        this.performWrite(mirrorCommand, execute);
    }

    @Override
    public void writeFloatValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, float value, byte type, MirrorCommand mirrorCommand, boolean execute) {
        this.performWrite(mirrorCommand, execute);
    }

    @Override
    public void writeScaledValue(ASDUHeader header, InformationObjectAddress informationObjectAddress, short value, byte type, MirrorCommand mirrorCommand, boolean execute) {
        this.performWrite(mirrorCommand, execute);
    }

    protected synchronized void handleWriteCommand(MirrorCommand mirrorCommand) {
        mirrorCommand.sendActivationTermination();
    }

    private final class BackgroundIteratorImpl
    implements BackgroundIterator {
        private final AtomicInteger position = new AtomicInteger();

        private BackgroundIteratorImpl() {
        }

        @Override
        public Object nextMessage() {
            return SineDataModel.this.proceedBackgroundScan(this.position);
        }
    }
}

