/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.apci;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.neoscada.protocol.iec60870.apci.TimerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer {
    private static final Logger logger = LoggerFactory.getLogger(Timer.class);
    private final ChannelHandlerContext ctx;
    private final TimerHandler handler;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            Timer.this.handleTimeout();
        }
    };
    private ScheduledFuture<?> future;
    private final String name;

    public Timer(ChannelHandlerContext ctx, String name, TimerHandler timerHandler) {
        this.ctx = ctx;
        this.name = name;
        this.handler = timerHandler;
    }

    public synchronized void restart(long timeout) {
        logger.trace(String.valueOf(this.name) + ": restart:  {}", (Object)timeout);
        this.internalStop();
        this.internalStart(timeout);
    }

    public synchronized void start(long timeout) {
        logger.trace(String.valueOf(this.name) + ": start: {}", (Object)timeout);
        this.internalStart(timeout);
    }

    private void internalStart(long timeout) {
        if (this.future == null) {
            this.future = this.ctx.executor().schedule(this.runnable, timeout, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        logger.trace(String.valueOf(this.name) + ": stop");
        this.internalStop();
    }

    private void internalStop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTimeout() {
        boolean doCall;
        logger.debug(String.valueOf(this.name) + ": expired");
        Timer timer = this;
        synchronized (timer) {
            doCall = this.future != null;
            this.future = null;
        }
        if (doCall) {
            this.handler.handleTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Timer timer = this;
        synchronized (timer) {
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
        }
    }
}

