/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.client.data;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.Executor;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDUAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Value;
import org.eclipse.neoscada.protocol.iec60870.client.data.AbstractDataProcessor;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataListener;
import org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleContext;

public class DataProcessor
extends AbstractDataProcessor {
    private final DataListener listener;
    private final Executor executor;

    public DataProcessor(Executor executor, DataListener listener) {
        this.executor = executor;
        this.listener = listener;
    }

    @Override
    public void activated(DataModuleContext dataModuleContext, ChannelHandlerContext ctx) {
        dataModuleContext.requestStartData();
        dataModuleContext.startInterrogation(ASDUAddress.BROADCAST, (short)20);
    }

    @Override
    public void started() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DataProcessor.this.listener.started();
            }
        });
    }

    @Override
    public void disconnected() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DataProcessor.this.listener.disconnected();
            }
        });
    }

    @Override
    protected void fireEntry(final ASDUAddress asduAddress, final InformationObjectAddress address, final Value<?> value) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                DataProcessor.this.listener.update(asduAddress, address, value);
            }
        });
    }
}

