/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;

public enum HttpMethods implements Expression
{
    GET(false),
    PATCH(true),
    POST(true),
    PUT(true),
    DELETE(false),
    HEAD(false),
    OPTIONS(false),
    TRACE(false);

    final boolean entity;

    private HttpMethods(boolean entity) {
        this.entity = entity;
    }

    public HttpUriRequest createMethod(String url) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case GET -> new HttpGet(url);
            case PATCH -> new HttpPatch(url);
            case POST -> new HttpPost(url);
            case PUT -> new HttpPut(url);
            case DELETE -> new HttpDelete(url);
            case HEAD -> new HttpHead(url);
            case OPTIONS -> new HttpOptions(url);
            case TRACE -> new HttpTrace(url);
        };
    }

    public HttpUriRequest createMethod(URI uri) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case GET -> new HttpGet(uri);
            case PATCH -> new HttpPatch(uri);
            case POST -> new HttpPost(uri);
            case PUT -> new HttpPut(uri);
            case DELETE -> new HttpDelete(uri);
            case HEAD -> new HttpHead(uri);
            case OPTIONS -> new HttpOptions(uri);
            case TRACE -> new HttpTrace(uri);
        };
    }

    public final boolean isEntityEnclosing() {
        return this.entity;
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        return (T)ExpressionBuilder.constantExpression((Object)this.name()).evaluate(exchange, type);
    }
}

