/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.model.TemplatedRouteBeanDefinition;
import org.apache.camel.model.TemplatedRouteParameterDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="templatedRoute")
@XmlType(propOrder={"parameters", "beans"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TemplatedRouteDefinition
implements CamelContextAware {
    @XmlTransient
    private CamelContext camelContext;
    @XmlAttribute(required=true)
    private String routeTemplateRef;
    @XmlAttribute
    private String routeId;
    @XmlAttribute
    private String prefixId;
    @XmlElement(name="parameter")
    @Metadata(description="Adds an input parameter of the template to build the route")
    private List<TemplatedRouteParameterDefinition> parameters;
    @XmlElement(name="bean")
    @Metadata(description="Adds a local bean as input of the template to build the route")
    private List<TemplatedRouteBeanDefinition> beans;

    public String getRouteTemplateRef() {
        return this.routeTemplateRef;
    }

    public void setRouteTemplateRef(String routeTemplateRef) {
        this.routeTemplateRef = routeTemplateRef;
    }

    public List<TemplatedRouteParameterDefinition> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<TemplatedRouteParameterDefinition> parameters) {
        this.parameters = parameters;
    }

    public List<TemplatedRouteBeanDefinition> getBeans() {
        return this.beans;
    }

    public void setBeans(List<TemplatedRouteBeanDefinition> beans) {
        this.beans = beans;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getPrefixId() {
        return this.prefixId;
    }

    public void setPrefixId(String prefixId) {
        this.prefixId = prefixId;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public TemplatedRouteDefinition parameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    public TemplatedRouteDefinition parameters(Map<String, String> parameters) {
        parameters.forEach(this::addParameter);
        return this;
    }

    public TemplatedRouteDefinition bean(String name, Class<?> type) {
        if (this.beans == null) {
            this.beans = new ArrayList<TemplatedRouteBeanDefinition>();
        }
        TemplatedRouteBeanDefinition def = new TemplatedRouteBeanDefinition();
        def.setName(name);
        def.setBeanType(type);
        this.beans.add(def);
        return this;
    }

    public TemplatedRouteDefinition bean(String name, Object bean) {
        if (this.beans == null) {
            this.beans = new ArrayList<TemplatedRouteBeanDefinition>();
        }
        TemplatedRouteBeanDefinition def = new TemplatedRouteBeanDefinition();
        def.setName(name);
        if (bean instanceof RouteTemplateContext.BeanSupplier) {
            def.setBeanSupplier((RouteTemplateContext.BeanSupplier<Object>)((RouteTemplateContext.BeanSupplier)bean));
        } else if (bean instanceof Supplier) {
            def.setBeanSupplier((RouteTemplateContext.BeanSupplier<Object>)((RouteTemplateContext.BeanSupplier)ctx -> ((Supplier)bean).get()));
        } else if (bean instanceof String) {
            def.setType((String)bean);
        } else {
            def.setBeanSupplier((RouteTemplateContext.BeanSupplier<Object>)((RouteTemplateContext.BeanSupplier)ctx -> bean));
        }
        this.beans.add(def);
        return this;
    }

    public TemplatedRouteDefinition bean(String name, Supplier<Object> bean) {
        if (this.beans == null) {
            this.beans = new ArrayList<TemplatedRouteBeanDefinition>();
        }
        TemplatedRouteBeanDefinition def = new TemplatedRouteBeanDefinition();
        def.setName(name);
        def.setBeanSupplier((RouteTemplateContext.BeanSupplier<Object>)((RouteTemplateContext.BeanSupplier)ctx -> bean.get()));
        this.beans.add(def);
        return this;
    }

    public TemplatedRouteDefinition bean(String name, Class<?> type, RouteTemplateContext.BeanSupplier<Object> bean) {
        if (this.beans == null) {
            this.beans = new ArrayList<TemplatedRouteBeanDefinition>();
        }
        TemplatedRouteBeanDefinition def = new TemplatedRouteBeanDefinition();
        def.setName(name);
        def.setBeanType(type);
        def.setBeanSupplier(bean);
        this.beans.add(def);
        return this;
    }

    public TemplatedRouteDefinition bean(String name, String language, String script) {
        if (this.beans == null) {
            this.beans = new ArrayList<TemplatedRouteBeanDefinition>();
        }
        TemplatedRouteBeanDefinition def = new TemplatedRouteBeanDefinition();
        def.setName(name);
        def.setType(language);
        def.setScript(script);
        this.beans.add(def);
        return this;
    }

    public TemplatedRouteDefinition bean(String name, Class<?> type, String language, String script) {
        if (this.beans == null) {
            this.beans = new ArrayList<TemplatedRouteBeanDefinition>();
        }
        TemplatedRouteBeanDefinition def = new TemplatedRouteBeanDefinition();
        def.setName(name);
        def.setBeanType(type);
        def.setType(language);
        def.setScript(script);
        this.beans.add(def);
        return this;
    }

    public TemplatedRouteBeanDefinition bean(String name) {
        if (this.beans == null) {
            this.beans = new ArrayList<TemplatedRouteBeanDefinition>();
        }
        TemplatedRouteBeanDefinition def = new TemplatedRouteBeanDefinition();
        def.setParent(this);
        def.setName(name);
        this.beans.add(def);
        return def;
    }

    public TemplatedRouteDefinition prefixId(String id) {
        this.setPrefixId(id);
        return this;
    }

    public TemplatedRouteDefinition routeId(String id) {
        this.setRouteId(id);
        return this;
    }

    public TemplatedRouteDefinition routeTemplateRef(String ref) {
        this.setRouteTemplateRef(ref);
        return this;
    }

    private void addParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<TemplatedRouteParameterDefinition>();
        }
        this.parameters.add(new TemplatedRouteParameterDefinition(name, value));
    }
}

