/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.schema.validation;

import com.worldturner.medeia.api.FailedValidationResult;
import com.worldturner.medeia.api.OkValidationResult;
import com.worldturner.medeia.api.ValidationFailedException;
import com.worldturner.medeia.api.ValidationResult;
import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.schema.validation.DecodingResult;
import com.worldturner.medeia.schema.validation.SchemaValidator;
import com.worldturner.medeia.schema.validation.SchemaValidatorKt;
import com.worldturner.medeia.schema.validation.stream.SchemaValidatorInstance;
import com.worldturner.util.JsonParseException;
import com.worldturner.util.JsonValidator;
import java.net.URI;
import java.util.Base64;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/worldturner/medeia/schema/validation/ContentValidator;", "Lcom/worldturner/medeia/schema/validation/SchemaValidator;", "Lcom/worldturner/medeia/schema/validation/stream/SchemaValidatorInstance;", "contentMediaType", "", "contentEncoding", "(Ljava/lang/String;Ljava/lang/String;)V", "getContentEncoding", "()Ljava/lang/String;", "getContentMediaType", "createInstance", "startLevel", "", "recordUnknownRefs", "", "unknownRefs", "", "Ljava/net/URI;", "validate", "Lcom/worldturner/medeia/api/ValidationResult;", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "location", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "validateContentEncoding", "Lcom/worldturner/medeia/schema/validation/DecodingResult;", "string", "validateContentMediaType", "decoding", "Companion", "medeia-validator-core"})
public final class ContentValidator
implements SchemaValidator,
SchemaValidatorInstance {
    @Nullable
    private final String contentMediaType;
    @Nullable
    private final String contentEncoding;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getContentMediaType() {
        return this.contentMediaType;
    }

    @Nullable
    public final String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    @NotNull
    public SchemaValidatorInstance createInstance(int startLevel) {
        return this;
    }

    @Override
    public void recordUnknownRefs(@NotNull Collection<URI> unknownRefs) {
        Intrinsics.checkParameterIsNotNull(unknownRefs, (String)"unknownRefs");
    }

    @Override
    @Nullable
    public ValidationResult validate(@NotNull JsonTokenData token, @NotNull JsonTokenLocation location) {
        DecodingResult decodingResult;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        if (token.getType() != JsonTokenType.VALUE_TEXT) {
            return OkValidationResult.INSTANCE;
        }
        String string = token.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String text = string;
        DecodingResult it = decodingResult = this.validateContentEncoding(text, location);
        boolean bl = false;
        FailedValidationResult failedValidationResult = it.getFailure();
        if (failedValidationResult != null) {
            FailedValidationResult failedValidationResult2;
            FailedValidationResult it2 = failedValidationResult2 = failedValidationResult;
            boolean bl2 = false;
            return it2;
        }
        DecodingResult decoding = decodingResult;
        return this.validateContentMediaType(decoding, location);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final DecodingResult validateContentEncoding(String string, JsonTokenLocation location) {
        DecodingResult decodingResult;
        String string2 = this.contentEncoding;
        if (string2 != null) {
            String string3 = string2;
            switch (string3.hashCode()) {
                case -1396204209: {
                    void var4_7;
                    if (!string3.equals("base64")) break;
                    try {
                        byte[] byArray;
                        byte[] it = byArray = Base64.getDecoder().decode(string);
                        boolean bl = false;
                        DecodingResult decodingResult2 = new DecodingResult(it, null, null, 6, null);
                    }
                    catch (IllegalArgumentException e) {
                        DecodingResult decodingResult3 = new DecodingResult(null, null, new FailedValidationResult("contentEncoding", null, "Invalid base64 data: " + e.getMessage(), location, null, 18, null), 3, null);
                    }
                    decodingResult = var4_7;
                    return decodingResult;
                }
            }
        }
        decodingResult = new DecodingResult(null, string, null, 5, null);
        return decodingResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ValidationResult validateContentMediaType(DecodingResult decoding, JsonTokenLocation location) {
        ValidationResult validationResult;
        String string = this.contentMediaType;
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case -43840953: {
                    ValidationResult validationResult2;
                    if (!string2.equals("application/json")) break;
                    try {
                        new JsonValidator(decoding.toString());
                        validationResult2 = OkValidationResult.INSTANCE;
                    }
                    catch (JsonParseException e) {
                        Collection collection = null;
                        String string3 = "Invalid JSON: " + e.getMessage();
                        JsonTokenLocation jsonTokenLocation = location;
                        validationResult2 = new FailedValidationResult("contentMediaType", null, string3, jsonTokenLocation, collection, 18, null);
                    }
                    catch (ValidationFailedException e) {
                        validationResult2 = (ValidationResult)CollectionsKt.first(e.getFailures());
                    }
                    validationResult = validationResult2;
                    return validationResult;
                }
            }
        }
        validationResult = OkValidationResult.INSTANCE;
        return validationResult;
    }

    public ContentValidator(@Nullable String contentMediaType, @Nullable String contentEncoding) {
        String string;
        String string2;
        String string3;
        Locale locale;
        String string4;
        String it;
        ContentValidator contentValidator;
        String string5;
        ContentValidator contentValidator2 = this;
        String string6 = contentMediaType;
        if (string6 != null) {
            string5 = string6;
            contentValidator = contentValidator2;
            it = string5;
            boolean bl = false;
            string4 = it;
            Locale locale2 = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.US");
            locale = locale2;
            String string7 = string4;
            if (string7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.toLowerCase(locale);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase(locale)");
            string3 = string8;
            contentValidator2 = contentValidator;
            string2 = string3;
        } else {
            string2 = null;
        }
        contentValidator2.contentMediaType = string2;
        ContentValidator contentValidator3 = this;
        String string9 = contentEncoding;
        if (string9 != null) {
            string5 = string9;
            contentValidator = contentValidator3;
            it = string5;
            boolean bl = false;
            string4 = it;
            Locale locale3 = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.US");
            locale = locale3;
            String string10 = string4;
            if (string10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string11 = string10.toLowerCase(locale);
            Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"(this as java.lang.String).toLowerCase(locale)");
            string3 = string11;
            contentValidator3 = contentValidator;
            string = string3;
        } else {
            string = null;
        }
        contentValidator3.contentEncoding = string;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\b"}, d2={"Lcom/worldturner/medeia/schema/validation/ContentValidator$Companion;", "", "()V", "create", "Lcom/worldturner/medeia/schema/validation/ContentValidator;", "contentMediaType", "", "contentEncoding", "medeia-validator-core"})
    public static final class Companion {
        @Nullable
        public final ContentValidator create(@Nullable String contentMediaType, @Nullable String contentEncoding) {
            return SchemaValidatorKt.isAnyNotNull(contentMediaType, contentEncoding) ? new ContentValidator(contentMediaType, contentEncoding) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

