/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.rest.client.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.util.RegistryDateDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.http.HttpResponse;
import java.util.Date;
import java.util.function.Supplier;

public class BodyHandler<W>
implements HttpResponse.BodyHandler<Supplier<W>> {
    private final TypeReference<W> wClass;
    private final RestClientErrorHandler errorHandler;
    private static final ObjectMapper mapper = new ObjectMapper();

    public BodyHandler(TypeReference<W> wClass, RestClientErrorHandler errorHandler) {
        this.wClass = wClass;
        this.errorHandler = errorHandler;
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public HttpResponse.BodySubscriber<Supplier<W>> apply(HttpResponse.ResponseInfo responseInfo) {
        return BodyHandler.asJSON(this.wClass, responseInfo, this.errorHandler);
    }

    public static <W> HttpResponse.BodySubscriber<Supplier<W>> asJSON(TypeReference<W> targetType, HttpResponse.ResponseInfo responseInfo, RestClientErrorHandler errorHandler) {
        HttpResponse.BodySubscriber<InputStream> upstream = HttpResponse.BodySubscribers.ofInputStream();
        return HttpResponse.BodySubscribers.mapping(upstream, inputStream -> BodyHandler.toSupplierOfType(inputStream, targetType, responseInfo, errorHandler));
    }

    public static <W> Supplier<W> toSupplierOfType(InputStream body, TypeReference<W> targetType, HttpResponse.ResponseInfo responseInfo, RestClientErrorHandler errorHandler) {
        return () -> {
            try {
                if (BodyHandler.isFailure(responseInfo)) {
                    throw errorHandler.handleErrorResponse(body, responseInfo.statusCode());
                }
                String typeName = targetType.getType().getTypeName();
                if (typeName.contains("InputStream")) {
                    return body;
                }
                if (typeName.contains("Void")) {
                    return null;
                }
                return mapper.readValue(body, targetType);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private static boolean isFailure(HttpResponse.ResponseInfo responseInfo) {
        return responseInfo.statusCode() / 100 != 2;
    }

    static {
        SimpleModule module = new SimpleModule("Custom date handler");
        module.addDeserializer(Date.class, (JsonDeserializer)new RegistryDateDeserializer());
        mapper.registerModule((Module)module);
    }
}

