/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hipchat;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hipchat.HipchatEndpoint;
import org.apache.camel.component.hipchat.HipchatException;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="hipchat")
public class HipchatComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(HipchatComponent.class);

    public HipchatComponent() {
    }

    public HipchatComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HipchatEndpoint endpoint = this.getHipchatEndpoint(uri);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().getAuthToken() == null) {
            throw new HipchatException("OAuth 2 auth token must be specified");
        }
        this.parseUri(remaining, endpoint);
        LOG.debug("Using Hipchat API URL: {}", (Object)endpoint.getConfiguration().hipChatUrl());
        return endpoint;
    }

    private void parseUri(String remaining, HipchatEndpoint endpoint) throws Exception {
        String uri = URISupport.normalizeUri((String)remaining);
        URI hipChatUri = new URI(uri);
        if (hipChatUri.getHost() != null) {
            endpoint.getConfiguration().setHost(hipChatUri.getHost());
            if (hipChatUri.getPort() != -1) {
                endpoint.getConfiguration().setPort(hipChatUri.getPort());
            }
            endpoint.getConfiguration().setProtocol(hipChatUri.getScheme());
        }
    }

    protected HipchatEndpoint getHipchatEndpoint(String uri) {
        return new HipchatEndpoint(uri, this);
    }
}

