/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.hdfs.HdfsCompressionCodec;
import org.apache.camel.component.hdfs.HdfsEndpoint;
import org.apache.camel.component.hdfs.HdfsFileSystemType;
import org.apache.camel.component.hdfs.HdfsFileType;
import org.apache.camel.component.hdfs.WritableType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.hadoop.io.SequenceFile;

public class HdfsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        HdfsEndpoint target = (HdfsEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "append": {
                target.getConfig().setAppend((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "blocksize": 
            case "blockSize": {
                target.getConfig().setBlockSize((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "buffersize": 
            case "bufferSize": {
                target.getConfig().setBufferSize((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "checkidleinterval": 
            case "checkIdleInterval": {
                target.getConfig().setCheckIdleInterval((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "chunksize": 
            case "chunkSize": {
                target.getConfig().setChunkSize((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "compressioncodec": 
            case "compressionCodec": {
                target.getConfig().setCompressionCodec((HdfsCompressionCodec)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsCompressionCodec.class, (Object)value)));
                return true;
            }
            case "compressiontype": 
            case "compressionType": {
                target.getConfig().setCompressionType((SequenceFile.CompressionType)HdfsEndpointConfigurer.property((CamelContext)camelContext, SequenceFile.CompressionType.class, (Object)value));
                return true;
            }
            case "connectonstartup": 
            case "connectOnStartup": {
                target.getConfig().setConnectOnStartup((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                target.setDelay((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)HdfsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)HdfsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "filesystemtype": 
            case "fileSystemType": {
                target.getConfig().setFileSystemType((HdfsFileSystemType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsFileSystemType.class, (Object)value)));
                return true;
            }
            case "filetype": 
            case "fileType": {
                target.getConfig().setFileType((HdfsFileType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsFileType.class, (Object)value)));
                return true;
            }
            case "greedy": {
                target.setGreedy((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "kerberosconfigfilelocation": 
            case "kerberosConfigFileLocation": {
                target.getConfig().setKerberosConfigFileLocation((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberoskeytablocation": 
            case "kerberosKeytabLocation": {
                target.getConfig().setKerberosKeytabLocation((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosusername": 
            case "kerberosUsername": {
                target.getConfig().setKerberosUsername((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keytype": 
            case "keyType": {
                target.getConfig().setKeyType((WritableType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, WritableType.class, (Object)value)));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                target.getConfig().setMaxMessagesPerPoll((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "namednodes": 
            case "namedNodes": {
                target.getConfig().setNamedNodes((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "openedsuffix": 
            case "openedSuffix": {
                target.getConfig().setOpenedSuffix((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "overwrite": {
                target.getConfig().setOverwrite((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "owner": {
                target.getConfig().setOwner((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pattern": {
                target.getConfig().setPattern((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy((PollingConsumerPollStrategy)HdfsEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "readsuffix": 
            case "readSuffix": {
                target.getConfig().setReadSuffix((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "replication": {
                target.getConfig().setReplication((Short)HdfsEndpointConfigurer.property((CamelContext)camelContext, Short.TYPE, (Object)value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel((LoggingLevel)HdfsEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService((ScheduledExecutorService)HdfsEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(HdfsEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties((Map)HdfsEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "splitstrategy": 
            case "splitStrategy": {
                target.getConfig().setSplitStrategy((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "streamdownload": 
            case "streamDownload": {
                target.getConfig().setStreamDownload((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit((TimeUnit)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "valuetype": 
            case "valueType": {
                target.getConfig().setValueType((WritableType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, WritableType.class, (Object)value)));
                return true;
            }
        }
        return false;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "append": {
                return Boolean.TYPE;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return Integer.TYPE;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return Integer.TYPE;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return Integer.TYPE;
            }
            case "blocksize": 
            case "blockSize": {
                return Long.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "buffersize": 
            case "bufferSize": {
                return Integer.TYPE;
            }
            case "checkidleinterval": 
            case "checkIdleInterval": {
                return Integer.TYPE;
            }
            case "chunksize": 
            case "chunkSize": {
                return Integer.TYPE;
            }
            case "compressioncodec": 
            case "compressionCodec": {
                return HdfsCompressionCodec.class;
            }
            case "compressiontype": 
            case "compressionType": {
                return SequenceFile.CompressionType.class;
            }
            case "connectonstartup": 
            case "connectOnStartup": {
                return Boolean.TYPE;
            }
            case "delay": {
                return Long.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "filesystemtype": 
            case "fileSystemType": {
                return HdfsFileSystemType.class;
            }
            case "filetype": 
            case "fileType": {
                return HdfsFileType.class;
            }
            case "greedy": {
                return Boolean.TYPE;
            }
            case "initialdelay": 
            case "initialDelay": {
                return Long.TYPE;
            }
            case "kerberosconfigfilelocation": 
            case "kerberosConfigFileLocation": {
                return String.class;
            }
            case "kerberoskeytablocation": 
            case "kerberosKeytabLocation": {
                return String.class;
            }
            case "kerberosusername": 
            case "kerberosUsername": {
                return String.class;
            }
            case "keytype": 
            case "keyType": {
                return WritableType.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                return Integer.TYPE;
            }
            case "namednodes": 
            case "namedNodes": {
                return String.class;
            }
            case "openedsuffix": 
            case "openedSuffix": {
                return String.class;
            }
            case "overwrite": {
                return Boolean.TYPE;
            }
            case "owner": {
                return String.class;
            }
            case "pattern": {
                return String.class;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return PollingConsumerPollStrategy.class;
            }
            case "readsuffix": 
            case "readSuffix": {
                return String.class;
            }
            case "repeatcount": 
            case "repeatCount": {
                return Long.TYPE;
            }
            case "replication": {
                return Short.TYPE;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return LoggingLevel.class;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return ScheduledExecutorService.class;
            }
            case "scheduler": {
                return Object.class;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Map.class;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return Boolean.TYPE;
            }
            case "splitstrategy": 
            case "splitStrategy": {
                return String.class;
            }
            case "startscheduler": 
            case "startScheduler": {
                return Boolean.TYPE;
            }
            case "streamdownload": 
            case "streamDownload": {
                return Boolean.TYPE;
            }
            case "timeunit": 
            case "timeUnit": {
                return TimeUnit.class;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return Boolean.TYPE;
            }
            case "valuetype": 
            case "valueType": {
                return WritableType.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        HdfsEndpoint target = (HdfsEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "append": {
                return target.getConfig().isAppend();
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "blocksize": 
            case "blockSize": {
                return target.getConfig().getBlockSize();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "buffersize": 
            case "bufferSize": {
                return target.getConfig().getBufferSize();
            }
            case "checkidleinterval": 
            case "checkIdleInterval": {
                return target.getConfig().getCheckIdleInterval();
            }
            case "chunksize": 
            case "chunkSize": {
                return target.getConfig().getChunkSize();
            }
            case "compressioncodec": 
            case "compressionCodec": {
                return target.getConfig().getCompressionCodec();
            }
            case "compressiontype": 
            case "compressionType": {
                return target.getConfig().getCompressionType();
            }
            case "connectonstartup": 
            case "connectOnStartup": {
                return target.getConfig().isConnectOnStartup();
            }
            case "delay": {
                return target.getDelay();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "filesystemtype": 
            case "fileSystemType": {
                return target.getConfig().getFileSystemType();
            }
            case "filetype": 
            case "fileType": {
                return target.getConfig().getFileType();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "kerberosconfigfilelocation": 
            case "kerberosConfigFileLocation": {
                return target.getConfig().getKerberosConfigFileLocation();
            }
            case "kerberoskeytablocation": 
            case "kerberosKeytabLocation": {
                return target.getConfig().getKerberosKeytabLocation();
            }
            case "kerberosusername": 
            case "kerberosUsername": {
                return target.getConfig().getKerberosUsername();
            }
            case "keytype": 
            case "keyType": {
                return target.getConfig().getKeyType();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                return target.getConfig().getMaxMessagesPerPoll();
            }
            case "namednodes": 
            case "namedNodes": {
                return target.getConfig().getNamedNodes();
            }
            case "openedsuffix": 
            case "openedSuffix": {
                return target.getConfig().getOpenedSuffix();
            }
            case "overwrite": {
                return target.getConfig().isOverwrite();
            }
            case "owner": {
                return target.getConfig().getOwner();
            }
            case "pattern": {
                return target.getConfig().getPattern();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "readsuffix": 
            case "readSuffix": {
                return target.getConfig().getReadSuffix();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "replication": {
                return target.getConfig().getReplication();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "splitstrategy": 
            case "splitStrategy": {
                return target.getConfig().getSplitStrategy();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "streamdownload": 
            case "streamDownload": {
                return target.getConfig().isStreamDownload();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
            case "valuetype": 
            case "valueType": {
                return target.getConfig().getValueType();
            }
        }
        return null;
    }

    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Object.class;
            }
        }
        return null;
    }
}

