/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.service.ServiceHelper;

public class Enricher
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware,
CamelContextAware {
    private CamelContext camelContext;
    private String id;
    private String routeId;
    private final Expression expression;
    private AggregationStrategy aggregationStrategy;
    private boolean aggregateOnException;
    private boolean shareUnitOfWork;
    private int cacheSize;
    private boolean ignoreInvalidEndpoint;
    private boolean allowOptimisedComponents = true;
    private ProcessorExchangeFactory processorExchangeFactory;
    private SendDynamicProcessor sendDynamicProcessor;

    public Enricher(Expression expression) {
        this.expression = expression;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.sendDynamicProcessor.getEndpointUtilizationStatistics();
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(boolean aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public boolean isShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(boolean shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public boolean isAllowOptimisedComponents() {
        return this.allowOptimisedComponents;
    }

    public void setAllowOptimisedComponents(boolean allowOptimisedComponents) {
        this.allowOptimisedComponents = allowOptimisedComponents;
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final Exchange resourceExchange = this.createResourceExchange(exchange, ExchangePattern.InOut);
        return this.sendDynamicProcessor.process(resourceExchange, new AsyncCallback(){

            public void done(boolean doneSync) {
                if (!Enricher.this.isAggregateOnException() && resourceExchange.isFailed()) {
                    Enricher.copyResultsWithoutCorrelationId(exchange, resourceExchange);
                } else {
                    Enricher.prepareResult(exchange);
                    try {
                        ExchangeHelper.prepareAggregation((Exchange)exchange, (Exchange)resourceExchange);
                        MessageHelper.resetStreamCache((Message)exchange.getIn());
                        Exchange aggregatedExchange = Enricher.this.aggregationStrategy.aggregate(exchange, resourceExchange);
                        if (aggregatedExchange != null) {
                            Enricher.copyResultsWithoutCorrelationId(exchange, aggregatedExchange);
                            if (resourceExchange != null && !Enricher.this.isShareUnitOfWork()) {
                                ((ExtendedExchange)resourceExchange.adapt(ExtendedExchange.class)).handoverCompletions(exchange);
                            }
                        }
                    }
                    catch (Throwable e) {
                        exchange.setException((Throwable)new CamelExchangeException("Error occurred during aggregation", exchange, e));
                    }
                }
                Enricher.this.processorExchangeFactory.release(resourceExchange);
                callback.done(doneSync);
            }
        });
    }

    protected Exchange createResourceExchange(Exchange source, ExchangePattern pattern) {
        Exchange target = this.processorExchangeFactory.createCorrelatedCopy(source, false);
        target.setPattern(pattern);
        if (this.isShareUnitOfWork()) {
            target.setProperty(ExchangePropertyKey.PARENT_UNIT_OF_WORK, (Object)source.getUnitOfWork());
            ((ExtendedExchange)target.adapt(ExtendedExchange.class)).setUnitOfWork(source.getUnitOfWork());
        }
        return target;
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    private static AggregationStrategy defaultAggregationStrategy() {
        return new CopyAggregationStrategy();
    }

    public String toString() {
        return this.id;
    }

    protected void doBuild() throws Exception {
        this.sendDynamicProcessor = new SendDynamicProcessor(null, this.getExpression());
        this.sendDynamicProcessor.setCamelContext(this.camelContext);
        this.sendDynamicProcessor.setCacheSize(this.cacheSize);
        this.sendDynamicProcessor.setIgnoreInvalidEndpoint(this.ignoreInvalidEndpoint);
        this.sendDynamicProcessor.setAllowOptimisedComponents(this.allowOptimisedComponents);
        this.processorExchangeFactory = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getProcessorExchangeFactory().newProcessorExchangeFactory((Processor)this);
        this.processorExchangeFactory.setRouteId(this.getRouteId());
        this.processorExchangeFactory.setId(this.getId());
        if (this.aggregationStrategy == null) {
            this.aggregationStrategy = Enricher.defaultAggregationStrategy();
        }
        CamelContextAware.trySetCamelContext((Object)this.aggregationStrategy, (CamelContext)this.camelContext);
        ServiceHelper.buildService((Object[])new Object[]{this.processorExchangeFactory, this.sendDynamicProcessor});
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.processorExchangeFactory, this.aggregationStrategy, this.sendDynamicProcessor});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.aggregationStrategy, this.processorExchangeFactory, this.sendDynamicProcessor});
    }

    private static void copyResultsWithoutCorrelationId(Exchange target, Exchange source) {
        Object correlationId = source.removeProperty(ExchangePropertyKey.CORRELATION_ID);
        ExchangeHelper.copyResultsPreservePattern((Exchange)target, (Exchange)source);
        if (correlationId != null) {
            source.setProperty(ExchangePropertyKey.CORRELATION_ID, correlationId);
        }
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                Enricher.copyResultsWithoutCorrelationId(oldExchange, newExchange);
            }
            return oldExchange;
        }
    }
}

