/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs.kerberos;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class KerberosAuthentication {
    private final String username;
    private final String keyTabFileLocation;
    private final Configuration configuration;

    public KerberosAuthentication(Configuration configuration, String username, String keyTabFileLocation) {
        this.configuration = configuration;
        this.username = username;
        this.keyTabFileLocation = keyTabFileLocation;
    }

    public void loginWithKeytab() throws IOException {
        if (!new File(this.keyTabFileLocation).exists()) {
            throw new FileNotFoundException(String.format("KeyTab file [%s] could not be found.", this.keyTabFileLocation));
        }
        UserGroupInformation.setConfiguration((Configuration)this.configuration);
        UserGroupInformation.loginUserFromKeytab((String)this.username, (String)this.keyTabFileLocation);
    }
}

