/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.Closeable;
import org.apache.camel.Exchange;
import org.apache.camel.component.hdfs.HdfsArrayFileTypeHandler;
import org.apache.camel.component.hdfs.HdfsBloomMapFileHandler;
import org.apache.camel.component.hdfs.HdfsFile;
import org.apache.camel.component.hdfs.HdfsInfoFactory;
import org.apache.camel.component.hdfs.HdfsInputStream;
import org.apache.camel.component.hdfs.HdfsMapFileHandler;
import org.apache.camel.component.hdfs.HdfsNormalFileHandler;
import org.apache.camel.component.hdfs.HdfsOutputStream;
import org.apache.camel.component.hdfs.HdfsSequenceFileHandler;
import org.apache.camel.component.hdfs.Holder;

public enum HdfsFileType {
    NORMAL_FILE(new HdfsNormalFileHandler()),
    SEQUENCE_FILE(new HdfsSequenceFileHandler()),
    MAP_FILE(new HdfsMapFileHandler()),
    BLOOMMAP_FILE(new HdfsBloomMapFileHandler()),
    ARRAY_FILE(new HdfsArrayFileTypeHandler());

    private final HdfsFile file;

    private HdfsFileType(HdfsFile file) {
        this.file = file;
    }

    public Closeable createOutputStream(String hdfsPath, HdfsInfoFactory hdfsInfoFactory) {
        return this.file.createOutputStream(hdfsPath, hdfsInfoFactory);
    }

    public long append(HdfsOutputStream hdfsOutputStream, Object key, Object value, Exchange exchange) {
        return this.file.append(hdfsOutputStream, key, value, exchange);
    }

    public Closeable createInputStream(String hdfsPath, HdfsInfoFactory hdfsInfoFactory) {
        return this.file.createInputStream(hdfsPath, hdfsInfoFactory);
    }

    public long next(HdfsInputStream hdfsInputStream, Holder<Object> key, Holder<Object> value) {
        return this.file.next(hdfsInputStream, key, value);
    }
}

