/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.hdfs.HdfsCompressionCodec;
import org.apache.camel.component.hdfs.HdfsEndpoint;
import org.apache.camel.component.hdfs.HdfsFileSystemType;
import org.apache.camel.component.hdfs.HdfsFileType;
import org.apache.camel.component.hdfs.WritableType;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.hadoop.io.SequenceFile;

public class HdfsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        HdfsEndpoint target = (HdfsEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "append": {
                target.getConfig().setAppend((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "blocksize": 
            case "blockSize": {
                target.getConfig().setBlockSize((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "buffersize": 
            case "bufferSize": {
                target.getConfig().setBufferSize((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "checkidleinterval": 
            case "checkIdleInterval": {
                target.getConfig().setCheckIdleInterval((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "chunksize": 
            case "chunkSize": {
                target.getConfig().setChunkSize((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "compressioncodec": 
            case "compressionCodec": {
                target.getConfig().setCompressionCodec((HdfsCompressionCodec)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsCompressionCodec.class, (Object)value)));
                return true;
            }
            case "compressiontype": 
            case "compressionType": {
                target.getConfig().setCompressionType((SequenceFile.CompressionType)HdfsEndpointConfigurer.property((CamelContext)camelContext, SequenceFile.CompressionType.class, (Object)value));
                return true;
            }
            case "connectonstartup": 
            case "connectOnStartup": {
                target.getConfig().setConnectOnStartup((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                target.setDelay((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)HdfsEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)HdfsEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "filesystemtype": 
            case "fileSystemType": {
                target.getConfig().setFileSystemType((HdfsFileSystemType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsFileSystemType.class, (Object)value)));
                return true;
            }
            case "filetype": 
            case "fileType": {
                target.getConfig().setFileType((HdfsFileType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, HdfsFileType.class, (Object)value)));
                return true;
            }
            case "greedy": {
                target.setGreedy((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "kerberosconfigfilelocation": 
            case "kerberosConfigFileLocation": {
                target.getConfig().setKerberosConfigFileLocation((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberoskeytablocation": 
            case "kerberosKeytabLocation": {
                target.getConfig().setKerberosKeytabLocation((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "kerberosusername": 
            case "kerberosUsername": {
                target.getConfig().setKerberosUsername((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "keytype": 
            case "keyType": {
                target.getConfig().setKeyType((WritableType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, WritableType.class, (Object)value)));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                target.getConfig().setMaxMessagesPerPoll((Integer)HdfsEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "namednodes": 
            case "namedNodes": {
                target.getConfig().setNamedNodes((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "openedsuffix": 
            case "openedSuffix": {
                target.getConfig().setOpenedSuffix((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "overwrite": {
                target.getConfig().setOverwrite((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "owner": {
                target.getConfig().setOwner((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pattern": {
                target.getConfig().setPattern((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy((PollingConsumerPollStrategy)HdfsEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "readsuffix": 
            case "readSuffix": {
                target.getConfig().setReadSuffix((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount((Long)HdfsEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "replication": {
                target.getConfig().setReplication((Short)HdfsEndpointConfigurer.property((CamelContext)camelContext, Short.TYPE, (Object)value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel((LoggingLevel)HdfsEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService((ScheduledExecutorService)HdfsEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(HdfsEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties((Map)HdfsEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "splitstrategy": 
            case "splitStrategy": {
                target.getConfig().setSplitStrategy((String)HdfsEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "streamdownload": 
            case "streamDownload": {
                target.getConfig().setStreamDownload((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit((TimeUnit)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay((Boolean)HdfsEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "valuetype": 
            case "valueType": {
                target.getConfig().setValueType((WritableType)((Object)HdfsEndpointConfigurer.property((CamelContext)camelContext, WritableType.class, (Object)value)));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        HdfsEndpoint target = (HdfsEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "append": {
                return target.getConfig().isAppend();
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "blocksize": 
            case "blockSize": {
                return target.getConfig().getBlockSize();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "buffersize": 
            case "bufferSize": {
                return target.getConfig().getBufferSize();
            }
            case "checkidleinterval": 
            case "checkIdleInterval": {
                return target.getConfig().getCheckIdleInterval();
            }
            case "chunksize": 
            case "chunkSize": {
                return target.getConfig().getChunkSize();
            }
            case "compressioncodec": 
            case "compressionCodec": {
                return target.getConfig().getCompressionCodec();
            }
            case "compressiontype": 
            case "compressionType": {
                return target.getConfig().getCompressionType();
            }
            case "connectonstartup": 
            case "connectOnStartup": {
                return target.getConfig().isConnectOnStartup();
            }
            case "delay": {
                return target.getDelay();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "filesystemtype": 
            case "fileSystemType": {
                return target.getConfig().getFileSystemType();
            }
            case "filetype": 
            case "fileType": {
                return target.getConfig().getFileType();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "kerberosconfigfilelocation": 
            case "kerberosConfigFileLocation": {
                return target.getConfig().getKerberosConfigFileLocation();
            }
            case "kerberoskeytablocation": 
            case "kerberosKeytabLocation": {
                return target.getConfig().getKerberosKeytabLocation();
            }
            case "kerberosusername": 
            case "kerberosUsername": {
                return target.getConfig().getKerberosUsername();
            }
            case "keytype": 
            case "keyType": {
                return target.getConfig().getKeyType();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                return target.getConfig().getMaxMessagesPerPoll();
            }
            case "namednodes": 
            case "namedNodes": {
                return target.getConfig().getNamedNodes();
            }
            case "openedsuffix": 
            case "openedSuffix": {
                return target.getConfig().getOpenedSuffix();
            }
            case "overwrite": {
                return target.getConfig().isOverwrite();
            }
            case "owner": {
                return target.getConfig().getOwner();
            }
            case "pattern": {
                return target.getConfig().getPattern();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "readsuffix": 
            case "readSuffix": {
                return target.getConfig().getReadSuffix();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "replication": {
                return target.getConfig().getReplication();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "splitstrategy": 
            case "splitStrategy": {
                return target.getConfig().getSplitStrategy();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "streamdownload": 
            case "streamDownload": {
                return target.getConfig().isStreamDownload();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
            case "valuetype": 
            case "valueType": {
                return target.getConfig().getValueType();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("hostName", String.class);
        map.put("port", Integer.TYPE);
        map.put("path", String.class);
        map.put("connectOnStartup", Boolean.TYPE);
        map.put("fileSystemType", HdfsFileSystemType.class);
        map.put("fileType", HdfsFileType.class);
        map.put("keyType", WritableType.class);
        map.put("namedNodes", String.class);
        map.put("owner", String.class);
        map.put("valueType", WritableType.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("pattern", String.class);
        map.put("sendEmptyMessageWhenIdle", Boolean.TYPE);
        map.put("streamDownload", Boolean.TYPE);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("pollStrategy", PollingConsumerPollStrategy.class);
        map.put("append", Boolean.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("overwrite", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("blockSize", Long.TYPE);
        map.put("bufferSize", Integer.TYPE);
        map.put("checkIdleInterval", Integer.TYPE);
        map.put("chunkSize", Integer.TYPE);
        map.put("compressionCodec", HdfsCompressionCodec.class);
        map.put("compressionType", SequenceFile.CompressionType.class);
        map.put("openedSuffix", String.class);
        map.put("readSuffix", String.class);
        map.put("replication", Short.TYPE);
        map.put("splitStrategy", String.class);
        map.put("synchronous", Boolean.TYPE);
        map.put("maxMessagesPerPoll", Integer.TYPE);
        map.put("backoffErrorThreshold", Integer.TYPE);
        map.put("backoffIdleThreshold", Integer.TYPE);
        map.put("backoffMultiplier", Integer.TYPE);
        map.put("delay", Long.TYPE);
        map.put("greedy", Boolean.TYPE);
        map.put("initialDelay", Long.TYPE);
        map.put("repeatCount", Long.TYPE);
        map.put("runLoggingLevel", LoggingLevel.class);
        map.put("scheduledExecutorService", ScheduledExecutorService.class);
        map.put("scheduler", Object.class);
        map.put("schedulerProperties", Map.class);
        map.put("startScheduler", Boolean.TYPE);
        map.put("timeUnit", TimeUnit.class);
        map.put("useFixedDelay", Boolean.TYPE);
        map.put("kerberosConfigFileLocation", String.class);
        map.put("kerberosKeytabLocation", String.class);
        map.put("kerberosUsername", String.class);
        ALL_OPTIONS = map;
    }
}

