/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.zookeeper.common.ZKHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKTrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOG = LoggerFactory.getLogger(ZKTrustManager.class);
    private X509ExtendedTrustManager x509ExtendedTrustManager;
    private boolean serverHostnameVerificationEnabled;
    private boolean clientHostnameVerificationEnabled;
    private ZKHostnameVerifier hostnameVerifier;

    ZKTrustManager(X509ExtendedTrustManager x509ExtendedTrustManager, boolean serverHostnameVerificationEnabled, boolean clientHostnameVerificationEnabled) {
        this.x509ExtendedTrustManager = x509ExtendedTrustManager;
        this.serverHostnameVerificationEnabled = serverHostnameVerificationEnabled;
        this.clientHostnameVerificationEnabled = clientHostnameVerificationEnabled;
        this.hostnameVerifier = new ZKHostnameVerifier();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.x509ExtendedTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.x509ExtendedTrustManager.checkClientTrusted(chain, authType, socket);
        if (this.clientHostnameVerificationEnabled) {
            this.performHostVerification(socket.getInetAddress(), chain[0]);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.x509ExtendedTrustManager.checkServerTrusted(chain, authType, socket);
        if (this.serverHostnameVerificationEnabled) {
            this.performHostVerification(socket.getInetAddress(), chain[0]);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.x509ExtendedTrustManager.checkClientTrusted(chain, authType, engine);
        if (this.clientHostnameVerificationEnabled) {
            try {
                this.performHostVerification(InetAddress.getByName(engine.getPeerHost()), chain[0]);
            }
            catch (UnknownHostException e) {
                throw new CertificateException("Failed to verify host", e);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.x509ExtendedTrustManager.checkServerTrusted(chain, authType, engine);
        if (this.serverHostnameVerificationEnabled) {
            try {
                this.performHostVerification(InetAddress.getByName(engine.getPeerHost()), chain[0]);
            }
            catch (UnknownHostException e) {
                throw new CertificateException("Failed to verify host", e);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.x509ExtendedTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.x509ExtendedTrustManager.checkServerTrusted(chain, authType);
    }

    private void performHostVerification(InetAddress inetAddress, X509Certificate certificate) throws CertificateException {
        String hostAddress = "";
        String hostName = "";
        try {
            hostAddress = inetAddress.getHostAddress();
            this.hostnameVerifier.verify(hostAddress, certificate);
        }
        catch (SSLException addressVerificationException) {
            try {
                LOG.debug("Failed to verify host address: {} attempting to verify host name with reverse dns lookup", (Object)hostAddress, (Object)addressVerificationException);
                hostName = inetAddress.getHostName();
                this.hostnameVerifier.verify(hostName, certificate);
            }
            catch (SSLException hostnameVerificationException) {
                LOG.error("Failed to verify host address: {}", (Object)hostAddress, (Object)addressVerificationException);
                LOG.error("Failed to verify hostname: {}", (Object)hostName, (Object)hostnameVerificationException);
                throw new CertificateException("Failed to verify both host address and host name", hostnameVerificationException);
            }
        }
    }
}

