/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.errorhandler;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.errorhandler.DefaultExceptionPolicyStrategy;
import org.apache.camel.processor.errorhandler.ExceptionPolicy;
import org.apache.camel.processor.errorhandler.ExceptionPolicyKey;
import org.apache.camel.processor.errorhandler.ExceptionPolicyStrategy;
import org.apache.camel.support.ChildServiceSupport;

public abstract class ErrorHandlerSupport
extends ChildServiceSupport
implements ErrorHandler {
    protected final Map<ExceptionPolicyKey, ExceptionPolicy> exceptionPolicies = new LinkedHashMap<ExceptionPolicyKey, ExceptionPolicy>();
    protected ExceptionPolicyStrategy exceptionPolicy = ErrorHandlerSupport.createDefaultExceptionPolicyStrategy();

    public void addErrorHandler(Processor errorHandler) {
        this.addChildService(errorHandler);
    }

    public void addExceptionPolicy(ExceptionPolicyKey key, ExceptionPolicy policy) {
        this.exceptionPolicies.put(key, policy);
    }

    protected ExceptionPolicy getExceptionPolicy(Exchange exchange, Throwable exception) {
        if (this.exceptionPolicy == null) {
            throw new IllegalStateException("The exception policy has not been set");
        }
        ExceptionPolicyKey key = this.exceptionPolicy.getExceptionPolicy(this.exceptionPolicies.keySet(), exchange, exception);
        return key != null ? this.exceptionPolicies.get(key) : null;
    }

    public void setExceptionPolicy(ExceptionPolicyStrategy exceptionPolicy) {
        if (exceptionPolicy != null) {
            this.exceptionPolicy = exceptionPolicy;
        }
    }

    public static ExceptionPolicyStrategy createDefaultExceptionPolicyStrategy() {
        return new DefaultExceptionPolicyStrategy();
    }

    public abstract boolean supportTransacted();

    public boolean isDeadLetterChannel() {
        return false;
    }

    public abstract Processor getOutput();
}

