/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider;

final class HaConfigurationBuilder {
    private static final String HFDS_NAMED_SERVICE = "hfdsNamedService";
    private static final String HFDS_NAMED_SERVICE_SEPARATOR = "_";
    private static final String HFDS_FS = "fs.defaultFS";

    private HaConfigurationBuilder() {
    }

    static void withClusterConfiguration(Configuration configuration, HdfsConfiguration endpointConfig) {
        String haNamedService = HaConfigurationBuilder.getSanitizedClusterName(endpointConfig.getHostName());
        HaConfigurationBuilder.withClusterConfiguration(configuration, haNamedService, endpointConfig.getNamedNodeList(), endpointConfig.getReplication());
    }

    static void withClusterConfiguration(Configuration configuration, String haNamedService, List<String> namedNodes, int replicationFactor) {
        configuration.set("dfs.replication", Integer.toString(replicationFactor));
        configuration.set("dfs.nameservices", haNamedService);
        configuration.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{haNamedService}), HaConfigurationBuilder.nodeToString(namedNodes.stream().map(HaConfigurationBuilder::nodeToString).collect(Collectors.joining(","))));
        namedNodes.forEach(nodeName -> configuration.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{haNamedService, HaConfigurationBuilder.nodeToString(nodeName)}), nodeName));
        configuration.set("dfs.client.failover.proxy.provider." + haNamedService, ConfiguredFailoverProxyProvider.class.getName());
        configuration.set(HFDS_FS, "hdfs://" + haNamedService);
    }

    static String getSanitizedClusterName(String rawClusterName) {
        String clusterName = HFDS_NAMED_SERVICE;
        if (StringUtils.isNotEmpty((String)rawClusterName)) {
            clusterName = rawClusterName.replace(".", HFDS_NAMED_SERVICE_SEPARATOR);
        }
        return clusterName;
    }

    private static String nodeToString(String nodeName) {
        return nodeName.replaceAll(":[0-9]*", "").replaceAll("\\.", HFDS_NAMED_SERVICE_SEPARATOR);
    }
}

