/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.extract;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.extract.GenericFieldExtractor;
import com.hazelcast.sql.impl.extract.GenericTargetAccessor;
import com.hazelcast.sql.impl.extract.GenericTargetExtractor;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.type.QueryDataType;

public class GenericQueryTarget
implements QueryTarget,
GenericTargetAccessor {
    private final InternalSerializationService serializationService;
    private final Extractors extractors;
    private final boolean key;
    private Object rawTarget;
    private Object target;

    public GenericQueryTarget(InternalSerializationService serializationService, Extractors extractors, boolean key) {
        this.serializationService = serializationService;
        this.extractors = extractors;
        this.key = key;
    }

    @Override
    public void setTarget(Object target) {
        this.rawTarget = target;
        this.target = null;
    }

    @Override
    public QueryExtractor createExtractor(String path, QueryDataType type) {
        if (path == null) {
            return new GenericTargetExtractor(this.key, this, type);
        }
        return new GenericFieldExtractor(this.key, this, type, this.extractors, path);
    }

    @Override
    public Object getTargetForFieldAccess() {
        if (this.target == null) {
            Data rawTarget0;
            this.target = this.rawTarget instanceof Data ? ((rawTarget0 = (Data)this.rawTarget).isPortable() ? this.rawTarget : this.serializationService.toObject(this.rawTarget)) : (this.rawTarget instanceof Portable ? this.serializationService.toData(this.rawTarget) : this.rawTarget);
        }
        return this.target;
    }

    @Override
    public Object getTargetDeserialized() {
        boolean cacheDeserialized;
        if (!(this.rawTarget instanceof Data)) {
            return this.rawTarget;
        }
        if (this.target != null && !(this.target instanceof Data)) {
            return this.target;
        }
        Data rawTarget0 = (Data)this.rawTarget;
        Object result = this.serializationService.toObject(rawTarget0);
        boolean bl = cacheDeserialized = this.target == null && !rawTarget0.isPortable() && !rawTarget0.isJson();
        if (cacheDeserialized) {
            this.target = result;
        }
        return result;
    }

    public boolean isKey() {
        return this.key;
    }
}

