/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.scan.KeyValueIterator;
import java.util.Iterator;
import java.util.Map;

public class MapScanExecIterator
implements KeyValueIterator {
    private final MapContainer map;
    private final Iterator<Integer> partsIterator;
    private final long now = Clock.currentTimeMillis();
    private RecordStore currentRecordStore;
    private Iterator<Map.Entry<Data, Record<Object>>> currentRecordStoreIterator;
    private Data currentKey;
    private Object currentValue;
    private Data nextKey;
    private Object nextValue;

    public MapScanExecIterator(MapContainer map, Iterator<Integer> partsIterator) {
        this.map = map;
        this.partsIterator = partsIterator;
        this.advance0();
    }

    @Override
    public boolean tryAdvance() {
        if (!this.done()) {
            this.currentKey = this.nextKey;
            this.currentValue = this.nextValue;
            this.advance0();
            return true;
        }
        return false;
    }

    @Override
    public boolean done() {
        return this.nextKey == null;
    }

    private void advance0() {
        while (true) {
            if (this.currentRecordStoreIterator == null) {
                if (!this.partsIterator.hasNext()) {
                    this.nextKey = null;
                    this.nextValue = null;
                    return;
                }
                int nextPart = this.partsIterator.next();
                boolean isOwned = this.map.getMapServiceContext().getOrInitCachedMemberPartitions().contains(nextPart);
                if (!isOwned) {
                    throw QueryException.error(1005, "Partition is not owned by member: " + nextPart).markInvalidate();
                }
                this.currentRecordStore = this.map.getMapServiceContext().getRecordStore(nextPart, this.map.getName());
                if (this.currentRecordStore == null) continue;
                try {
                    this.currentRecordStore.checkIfLoaded();
                }
                catch (RetryableHazelcastException e) {
                    throw QueryException.error(1007, "Map loading is in progress: " + this.map.getName(), e);
                }
                this.currentRecordStoreIterator = this.currentRecordStore.getStorage().mutationTolerantIterator();
            }
            assert (this.currentRecordStoreIterator != null);
            while (this.currentRecordStoreIterator.hasNext()) {
                Map.Entry<Data, Record<Object>> entry = this.currentRecordStoreIterator.next();
                if (this.currentRecordStore.isExpired(entry.getValue(), this.now, false)) continue;
                this.nextKey = entry.getKey();
                this.nextValue = entry.getValue().getValue();
                return;
            }
            this.currentRecordStore = null;
            this.currentRecordStoreIterator = null;
        }
    }

    @Override
    public Object getKey() {
        return this.currentKey;
    }

    @Override
    public Object getValue() {
        return this.currentValue;
    }
}

