/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCPollMCEventsCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.management.dto.MCEventDTO;
import com.hazelcast.internal.management.events.Event;
import com.hazelcast.internal.nio.Connection;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PollMCEventsMessageTask
extends AbstractCallableMessageTask<Void> {
    public PollMCEventsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        ManagementCenterService mcs = this.nodeEngine.getManagementCenterService();
        if (mcs == null) {
            return Collections.emptyList();
        }
        List<Event> polledEvents = mcs.pollMCEvents();
        ArrayList<MCEventDTO> result = new ArrayList<MCEventDTO>(polledEvents.size());
        for (Event event : polledEvents) {
            result.add(MCEventDTO.fromEvent(event));
        }
        return result;
    }

    @Override
    protected Void decodeClientMessage(ClientMessage clientMessage) {
        return null;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCPollMCEventsCodec.encodeResponse((List)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "pollMCEvents";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

